/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.armorstand;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;

public class ArmorStandInstance {
    private static final Vector UP = new Vector(0, 1, 0);
    private final ArmorStand armorStand;
    private final LivingEntity target;
    private final boolean follow;
    private double forward;
    private double upward;
    private double right;

    public boolean isValid() {
        return this.target.isValid() && this.armorStand.isValid();
    }

    public void remove() {
        Bukkit.getScheduler().runTask((Plugin)Fabled.inst(), () -> ((ArmorStand)this.armorStand).remove());
    }

    public void tick() {
        if (this.follow) {
            Bukkit.getScheduler().runTask((Plugin)Fabled.inst(), () -> {
                boolean chunkLoaded;
                boolean sameWorld = this.armorStand.getWorld().equals((Object)this.target.getWorld());
                Location loc = this.target.getLocation().clone();
                Vector dir = loc.getDirection().setY(0).normalize();
                Vector side = dir.clone().crossProduct(UP);
                loc.add(dir.multiply(this.forward)).add(0.0, this.upward, 0.0).add(side.multiply(this.right));
                if (!sameWorld && !(chunkLoaded = this.armorStand.getLocation().getChunk().isLoaded())) {
                    this.armorStand.getLocation().getChunk().load();
                }
                this.armorStand.teleport(loc);
            });
        }
    }

    @Generated
    public ArmorStandInstance(ArmorStand armorStand, LivingEntity target, boolean follow, double forward, double upward, double right) {
        this.armorStand = armorStand;
        this.target = target;
        this.follow = follow;
        this.forward = forward;
        this.upward = upward;
        this.right = right;
    }

    @Generated
    public ArmorStandInstance(ArmorStand armorStand, LivingEntity target, boolean follow) {
        this.armorStand = armorStand;
        this.target = target;
        this.follow = follow;
    }
}

