/**
 * Fabled
 * studio.magemonkey.fabled.cmd.CmdReset
 * <p>
 * The MIT License (MIT)
 * <p>
 * Copyright (c) 2024 MageMonkeyStudio
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software") to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package studio.magemonkey.fabled.cmd;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;

/**
 * A command that allows a player to profess through classes
 */
public class CmdReset implements IFunction {
    private static final String CANNOT_USE   = "cannot-use";
    private static final String RESET        = "reset";
    private static final String CONFIRM      = "confirm";
    private static final String INSTRUCTIONS = "instructions";
    private static final String DISABLED     = "world-disabled";

    /**
     * Runs the command
     *
     * @param cmd    command that was executed
     * @param plugin plugin reference
     * @param sender sender of the command
     * @param args   argument list
     * @param silent
     */
    @Override
    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        // Disabled world
        if (sender instanceof Player && !Fabled.getSettings().isWorldEnabled(((Player) sender).getWorld())) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent);
        }

        // Only players have profession options
        else if (sender instanceof Player) {
            if (args.length == 0 || !args[0].equalsIgnoreCase("confirm")) {
                cmd.sendMessage(sender,
                        CONFIRM,
                        ChatColor.DARK_RED + "This will delete your active account's data entirely", silent);
                cmd.sendMessage(sender,
                        INSTRUCTIONS,
                        ChatColor.GRAY + "Type " + ChatColor.GOLD + "/class reset confirm" + ChatColor.GRAY
                                + " to continue", silent);
            } else {
                PlayerData data = Fabled.getData((Player) sender);
                data.resetAll();
                data.updatePlayerStat(((Player) sender).getPlayer());
                cmd.sendMessage(sender, RESET, ChatColor.DARK_GREEN + "You have reset your active account data", silent);
            }
        }

        // Console doesn't have profession options
        else {
            cmd.sendMessage(sender, CANNOT_USE, ChatColor.RED + "This cannot be used by the console", silent);
        }
    }
}
