/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.event.FlagApplyEvent;
import studio.magemonkey.fabled.api.event.FlagExpireEvent;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.api.event.PlayerCastSkillEvent;
import studio.magemonkey.fabled.api.event.TrueDamageEvent;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.data.TitleType;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.ListenerUtil;
import studio.magemonkey.fabled.manager.TitleManager;

public class StatusListener
extends FabledListener {
    private static final Map<String, Long> messageTimers = new HashMap<String, Long>();
    private static final Set<String> interrupts = new HashSet<String>(){
        {
            this.add("stun");
            this.add("silence");
        }
    };
    private static final Map<String, String> messageMap = new HashMap<String, String>(){
        {
            this.put("stun", "stunned");
            this.put("root", "rooted");
            this.put("invincible", "invincible");
            this.put("absorb", "absorbed");
            this.put("disarm", "disarmed");
            this.put("silence", "silenced");
            this.put("channeling", "channeling");
            this.put("channel", "channeling");
        }
    };
    private final Vector ZERO = new Vector(0, 0, 0);

    @Override
    public void cleanup() {
        messageTimers.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        FlagManager.clearFlags((LivingEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMove(PlayerMoveEvent event) {
        if ((event.getPlayer().isOnGround() || event.getTo().getY() > event.getFrom().getY()) && this.check((Cancellable)event, (LivingEntity)event.getPlayer(), (LivingEntity)event.getPlayer(), "stun", "root", "channeling")) {
            event.getPlayer().setVelocity(this.ZERO);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInterrupt(FlagApplyEvent event) {
        if (interrupts.contains(event.getFlag()) && FlagManager.hasFlag(event.getEntity(), "channeling")) {
            FlagManager.removeFlag(event.getEntity(), "channeling");
            FlagManager.removeFlag(event.getEntity(), "channel");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlag(FlagApplyEvent event) {
        if ((event.getFlag().equals("stun") || event.getFlag().equals("root") || event.getFlag().equals("channeling")) && !(event.getEntity() instanceof Player)) {
            event.getEntity().addPotionEffect(new PotionEffect(NamespaceResolver.getPotion((String[])new String[]{"SLOWNESS", "SLOW"}), event.getTicks(), 100));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInvulnerable(FlagApplyEvent event) {
        if (event.getFlag().equals("invulnerable")) {
            event.getEntity().setInvulnerable(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void offInvulnerable(FlagExpireEvent event) {
        if (event.getFlag().equals("invulnerable")) {
            event.getEntity().setInvulnerable(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || DefaultCombatProtection.isFakeDamageEvent(event)) {
            return;
        }
        LivingEntity damager = ListenerUtil.getDamager(event);
        this.check((Cancellable)event, damager, damager, "stun", "disarm");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysicalDamage(PhysicalDamageEvent event) {
        this.check(event, event.getDamager(), event.getDamager(), "channel");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamaged(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || event instanceof EntityDamageByEntityEvent && DefaultCombatProtection.isFakeDamageEvent((EntityDamageByEntityEvent)event) || !(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        this.checkAbsorbAndInvincible((LivingEntity)event.getEntity(), (Cancellable)event, event.getDamage());
    }

    @EventHandler
    public void onTrueDamage(TrueDamageEvent event) {
        this.checkAbsorbAndInvincible(event.getTarget(), event, event.getDamage());
    }

    private void checkAbsorbAndInvincible(LivingEntity entity, Cancellable event, double damage) {
        if (this.check(event, entity, null, "absorb")) {
            double maxHealth = Objects.requireNonNull(entity.getAttribute(VersionManager.getNms().getAttribute("MAX_HEALTH"))).getValue();
            entity.setHealth(Math.max(Math.min(entity.getHealth() + damage, maxHealth), 0.0));
        } else {
            this.check(event, entity, null, "invincible");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)event.getEntity().getShooter();
            this.check((Cancellable)event, shooter, shooter, "stun", "disarm", "channeling");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCast(PlayerCastSkillEvent event) {
        this.check(event, (LivingEntity)event.getPlayer(), (LivingEntity)event.getPlayer(), "silence", "stun", "channel");
    }

    private boolean checkTime(Player player) {
        if (!messageTimers.containsKey(player.getName()) || System.currentTimeMillis() - messageTimers.get(player.getName()) > 1000L) {
            messageTimers.put(player.getName(), System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private boolean check(Cancellable event, LivingEntity entity, LivingEntity receiver, String ... flags) {
        for (String flag : flags) {
            Player player;
            if (!FlagManager.hasFlag(entity, flag)) continue;
            if (receiver instanceof Player && this.checkTime(player = (Player)receiver)) {
                TitleManager.show(player, TitleType.STATUS, "Status." + messageMap.get(flag), RPGFilter.DURATION.setReplacement("" + FlagManager.getTimeLeft(entity, flag)));
            }
            event.setCancelled(true);
            return true;
        }
        return false;
    }
}

