/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.warp;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.dynamic.mechanic.warp.AbstractWarpingMechanic;

public class WarpMechanic
extends AbstractWarpingMechanic {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String WALL = "walls";
    private static final String OPEN = "open";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";

    @Override
    public String getKey() {
        return "warp";
    }

    private Location getLocation(LivingEntity caster, int level, LivingEntity target) {
        boolean throughWalls = this.settings.getBool(WALL, false);
        boolean openOnly = this.settings.getBool(OPEN, true);
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        Vector dir = target.getLocation().getDirection();
        Vector side = dir.clone().crossProduct(UP).multiply(right);
        Location loc = target.getLocation().add(dir.multiply(forward)).add(side).add(0.0, upward, 0.0);
        if (openOnly) {
            loc.add(0.0, 1.0, 0.0);
            loc = TargetHelper.getOpenLocation(target.getLocation().add(0.0, 1.0, 0.0), loc, throughWalls);
            if (!loc.getBlock().getType().isSolid() && loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                loc.add(0.0, 1.0, 0.0);
            }
            return loc.subtract(0.0, 1.0, 0.0);
        }
        return loc;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        for (LivingEntity target : targets) {
            this.warp(target, caster, this.getLocation(caster, level, target), level);
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        ParticleHelper.play(WarpMechanic.this.getLocation((LivingEntity)caster, level, target), WarpMechanic.this.preview, Set.of(caster), "per-target-", WarpMechanic.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

