/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.projectile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.ParticleProjectileExpireEvent;
import studio.magemonkey.fabled.api.event.ParticleProjectileHitEvent;
import studio.magemonkey.fabled.api.event.ParticleProjectileLandEvent;
import studio.magemonkey.fabled.api.event.ParticleProjectileLaunchEvent;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.api.util.Nearby;
import studio.magemonkey.fabled.dynamic.DynamicSkill;

public class ParticleProjectile
extends CustomProjectile {
    public static final String SPEED = "velocity";
    public static final String STEPS = "steps";
    public static final String GRAVITY = "gravity";
    public static final String DRAG = "drag";
    public static final String PERIOD = "period";
    public static final String HOMING = "homing";
    public static final String HOMING_TARGET = "target";
    public static final String HOMING_DIST = "homing-distance";
    public static final String REMEMBER = "remember-key";
    public static final String CORRECTION = "correction";
    public static final String WALL = "wall";
    public static final String RADIUS = "collision-radius";
    @Deprecated
    public static final String LEGACY_FREQUENCY = "frequency";
    private static final String PIERCE = "pierce";
    private Location loc;
    private final Location startingLocation;
    private Vector vel;
    private int life;
    private final int distance;
    private final int steps;
    private final double radius;
    private final double gravity;
    private final double drag;
    private final int particlePeriod;
    private int count;
    private final boolean pierce;
    protected Consumer<Location> onStep;
    protected Supplier<LivingEntity> homing;
    protected double correction;

    public ParticleProjectile(LivingEntity shooter, int level, Location loc, Settings settings, int lifespan, int distance) {
        super(shooter, settings);
        this.loc = loc;
        this.startingLocation = loc.clone();
        this.vel = loc.getDirection().multiply(settings.getAttr(SPEED, level, 1.0));
        this.life = lifespan;
        this.distance = distance;
        this.steps = settings.getInt(STEPS, 2);
        this.radius = settings.getAttr(RADIUS, level, 1.5);
        this.gravity = settings.getAttr(GRAVITY, level, -0.04);
        this.drag = settings.getAttr(DRAG, 0, 0.02);
        this.particlePeriod = settings.getInt(PERIOD, (int)(40.0 * settings.getDouble(LEGACY_FREQUENCY, 0.05)));
        this.pierce = settings.getBool(PIERCE, false);
        if (settings.getBool(HOMING, false)) {
            String target = settings.getString(HOMING_TARGET, "nearest");
            Comparator<LivingEntity> comparator = Comparator.comparingDouble(o -> o.getLocation().distanceSquared(this.getLocation()));
            this.homing = target.equalsIgnoreCase("remember target") ? () -> {
                Object data = DynamicSkill.getCastData(this.getShooter()).getRaw(this.settings.getString(REMEMBER, HOMING_TARGET));
                if (data == null) {
                    return null;
                }
                try {
                    return ((List)data).stream().filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(this.getLocation(), tar.getEyeLocation())).min(comparator).orElse(null);
                }
                catch (ClassCastException e) {
                    return null;
                }
            } : () -> Nearby.getLivingNearby(this.getLocation(), this.settings.getAttr(HOMING_DIST, 0, 20.0)).stream().filter(tar -> {
                if (tar == this.getShooter()) {
                    return false;
                }
                if (!Fabled.getSettings().isValidTarget((LivingEntity)tar)) {
                    return false;
                }
                boolean ally = Fabled.getSettings().isAlly(this.getShooter(), (LivingEntity)tar);
                if (ally && !this.ally) {
                    return false;
                }
                return ally || this.enemy;
            }).filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(this.getLocation(), tar.getEyeLocation())).min(comparator).orElse(null);
            this.correction = settings.getAttr(CORRECTION, 0, 0.2);
        }
        Bukkit.getPluginManager().callEvent((Event)new ParticleProjectileLaunchEvent(this));
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    public Location getStartLocation() {
        return this.startingLocation;
    }

    @Override
    protected Event expire() {
        return new ParticleProjectileExpireEvent(this);
    }

    @Override
    protected Event land() {
        return new ParticleProjectileLandEvent(this);
    }

    @Override
    protected Event hit(LivingEntity entity) {
        return new ParticleProjectileHitEvent(this, entity);
    }

    @Override
    protected boolean landed() {
        return TargetHelper.isSolid(this.getLocation().getBlock().getType());
    }

    @Override
    protected double getCollisionRadius() {
        return this.radius;
    }

    @Override
    public Vector getVelocity() {
        return this.vel;
    }

    public void teleport(Location loc) {
        this.loc = loc;
    }

    @Override
    public void setVelocity(Vector vel) {
        this.vel = vel;
    }

    public void setOnStep(Consumer<Location> onStep) {
        this.onStep = onStep;
    }

    public void run() {
        LivingEntity target;
        this.vel.setX(this.vel.getX() - this.drag * this.vel.getX());
        this.vel.setY(this.vel.getY() - this.drag * this.vel.getY() + this.gravity);
        this.vel.setZ(this.vel.getZ() - this.drag * this.vel.getZ());
        if (this.homing != null && (target = this.homing.get()) != null) {
            Vector acceleration = target.getBoundingBox().getCenter().subtract(this.getLocation().toVector()).normalize().multiply(this.settings.getAttr(SPEED, 0, 1.0)).subtract(this.vel);
            double length = acceleration.length();
            acceleration.multiply(1.0 / length).multiply(Math.min(length, this.correction));
            this.vel.add(acceleration);
        }
        double speed = this.vel.length();
        int steps = (int)Math.round(speed * (double)this.steps);
        Vector stepVector = this.vel.clone().multiply(1.0 / (double)steps);
        for (int i = 0; i < steps; ++i) {
            this.loc.add(stepVector);
            ++this.count;
            if (this.count >= this.particlePeriod) {
                this.count = 0;
                if (this.onStep == null) {
                    ParticleHelper.play(this.loc, this.settings);
                } else {
                    this.onStep.accept(this.loc);
                }
            }
            if (!this.isTraveling()) {
                return;
            }
            if (!this.checkCollision(this.pierce)) break;
        }
        --this.life;
        if (this.life <= 0) {
            if (this.settings.getBool("on-expire")) {
                this.callback.callback(this, null);
            }
            this.cancel();
            Bukkit.getPluginManager().callEvent((Event)new ParticleProjectileExpireEvent(this));
        } else if (this.loc.distanceSquared(this.startingLocation) >= (double)(this.distance * this.distance)) {
            if (this.settings.getBool("on-expire")) {
                this.callback.callback(this, null);
            }
            this.cancel();
            Bukkit.getPluginManager().callEvent((Event)new ParticleProjectileExpireEvent(this));
        }
    }

    public static List<ParticleProjectile> spread(LivingEntity shooter, int level, Vector direction, Location loc, Settings settings, double angle, int amount, ProjectileCallback callback, int lifespan, int distance) {
        List<Vector> dirs = ParticleProjectile.calcSpread(direction, angle, amount);
        ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
        for (Vector dir : dirs) {
            Location l = loc.clone();
            l.setDirection(dir);
            ParticleProjectile p = new ParticleProjectile(shooter, level, l, settings, lifespan, distance);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }

    public static List<ParticleProjectile> rain(LivingEntity shooter, int level, Location center, Settings settings, double radius, double height, int amount, ProjectileCallback callback, int lifespan, int distance) {
        Vector vel = new Vector(0, 1, 0);
        List<Location> locs = ParticleProjectile.calcRain(center, radius, height, amount);
        ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
        for (Location l : locs) {
            l.setDirection(vel);
            ParticleProjectile p = new ParticleProjectile(shooter, level, l, settings, lifespan, distance);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }
}

