/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUIType;
import studio.magemonkey.fabled.tree.basic.InventoryTree;

public class RequirementTree
extends InventoryTree {
    public RequirementTree(Fabled api, FabledClass tree) {
        super(api, tree);
    }

    @Override
    public void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        ArrayList<Skill> chained = new ArrayList<Skill>();
        ArrayList<Skill> unchained = new ArrayList<Skill>();
        for (Skill skill : skills) {
            if (this.isChained(skills, skill)) {
                chained.add(skill);
                continue;
            }
            unchained.add(skill);
        }
        int unchainedWidth = (unchained.size() + 5) / 6;
        int chainedWidth = 7 - unchainedWidth;
        if (unchainedWidth == 0) {
            chainedWidth = 8;
        }
        if (unchainedWidth > 0) {
            this.height = (unchained.size() + unchainedWidth - 1) / unchainedWidth;
        }
        int index = 0;
        unchained.sort(comparator);
        for (Skill skill : unchained) {
            int x = index % unchainedWidth;
            int y = index / unchainedWidth;
            ++index;
            this.skillSlots.put(x + y * 9, skill);
        }
        HashMap<Skill, Integer> tier = new HashMap<Skill, Integer>();
        HashMap<Skill, Integer> prevTier = new HashMap<Skill, Integer>();
        int row = 0;
        index = 0;
        do {
            tier.clear();
            for (Skill skill : chained) {
                boolean hasSkillReq;
                boolean bl = hasSkillReq = skill.getSkillReq() != null && Fabled.isSkillRegistered(skill.getSkillReq());
                if (!hasSkillReq && prevTier.size() == 0) {
                    tier.put(skill, index++);
                    continue;
                }
                if (!hasSkillReq || !prevTier.containsKey(Fabled.getSkill(skill.getSkillReq()))) continue;
                tier.put(skill, (Integer)prevTier.get(Fabled.getSkill(skill.getSkillReq())));
            }
            int filled = 0;
            for (int i = 0; i < index; ++i) {
                for (Map.Entry entry : tier.entrySet()) {
                    if ((Integer)entry.getValue() != i) continue;
                    int x = filled % chainedWidth + unchainedWidth + 1;
                    int y = filled / chainedWidth + row;
                    ++filled;
                    this.skillSlots.put(x + y * 9, (Skill)entry.getKey());
                }
            }
            prevTier.clear();
            for (Map.Entry entry : tier.entrySet()) {
                prevTier.put((Skill)entry.getKey(), (Integer)entry.getValue());
            }
            row += (tier.size() + chainedWidth - 1) / chainedWidth;
        } while (tier.size() > 0);
        if (row + 1 > this.height) {
            this.height = row + 1;
        }
        this.height = Math.max(1, Math.min(Fabled.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", this.height), 6));
    }

    private boolean isChained(List<Skill> skills, Skill skill) {
        if (Fabled.getSkill(skill.getSkillReq()) != null) {
            return true;
        }
        for (Skill s : skills) {
            if (Fabled.getSkill(s.getSkillReq()) != skill) continue;
            return true;
        }
        return false;
    }
}

