/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.hook.PlaceholderAPIHook;
import studio.magemonkey.fabled.hook.PluginChecker;
import studio.magemonkey.fabled.log.Logger;

public class ValuePlaceholderMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String PLACEHOLDER = "placeholder";
    private static final String EVALUATE = "evaluate";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value placeholder";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY);
        String placeholder = this.settings.getString(PLACEHOLDER);
        String type = this.settings.getString(TYPE).toUpperCase(Locale.US);
        boolean evaluate = this.settings.getBool(EVALUATE, false);
        String value = placeholder;
        if (PluginChecker.isPlaceholderAPIActive() && targets.get(0) instanceof Player) {
            value = PlaceholderAPIHook.format(placeholder, (Player)targets.get(0));
        }
        if (evaluate) {
            value = this.filter(caster, targets.get(0), value);
        }
        switch (type.charAt(0)) {
            case 'S': {
                DynamicSkill.getCastData(caster).put(key, value);
                break;
            }
            default: {
                try {
                    DynamicSkill.getCastData(caster).put(key, Double.parseDouble(value));
                    break;
                }
                catch (Exception ex) {
                    Logger.invalid(placeholder + " is not a valid numeric placeholder - PlaceholderAPI returned " + value);
                    return false;
                }
            }
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, DynamicSkill.getCastData(caster).getRaw(key));
        }
        return true;
    }
}

