/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.api.skills.SkillShot;

public class CmdForceCast
implements IFunction,
TabCompleter {
    private static final Pattern INTEGER = Pattern.compile("-?[0-9]+");
    private static final String NOT_PLAYER = "not-player";
    private static final String WRONG_SKILL = "wrong-skill";
    private static final String INVALID_SKILL = "invalid-skill";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (args.length < 2) {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        } else {
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                cmd.sendMessage(sender, NOT_PLAYER, String.valueOf(ChatColor.RED) + "That is not a valid player name", silent, new CustomFilter[0]);
                return;
            }
            Object name = args[1];
            int level = 1;
            for (int i = 2; i < args.length; ++i) {
                if (i == args.length - 1 && Fabled.getSkill((String)name) != null && INTEGER.matcher(args[i]).matches()) {
                    level = Integer.parseInt(args[i]);
                    continue;
                }
                name = (String)name + " " + args[i];
            }
            Skill skill = Fabled.getSkill((String)name);
            if (skill == null) {
                cmd.sendMessage(sender, INVALID_SKILL, String.valueOf(ChatColor.RED) + "That is not a valid skill", silent, new CustomFilter[0]);
            } else if (skill instanceof SkillShot) {
                ((SkillShot)((Object)skill)).cast((LivingEntity)player, level, true);
            } else {
                cmd.sendMessage(sender, WRONG_SKILL, String.valueOf(ChatColor.RED) + "Skills must be skill shot skills or dynamic skills to be cast this way.", silent, new CustomFilter[0]);
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length > 1) {
            return ConfigurableCommand.getTabCompletions((Collection)Fabled.getSkills().values().stream().filter(skill -> skill instanceof SkillShot).map(Skill::getKey).collect(Collectors.toList()), (String[])Arrays.copyOfRange(args, 1, args.length));
        }
        return null;
    }
}

