/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdForceAttr
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String RESET = "reset";
    private static final String RESET_ONE = "reset-one";
    private static final String RESET_ONE_FAIL = "reset-one-fail";
    private static final String NOT_ATTR = "not-attribute";
    private static final String NOT_NUM = "not-number";
    private static final String GAVE_ATTR = "gave-attributes";
    private static final String GAVE_ATTR_FAIL = "gave-attributes-fail";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (args.length < 1) {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
        if (player == null) {
            cmd.sendMessage(sender, NOT_PLAYER, String.valueOf(ChatColor.RED) + "That is not a valid player name", silent, new CustomFilter[0]);
            return;
        }
        PlayerData data = Fabled.getData(player);
        if (args.length == 1) {
            List<String> refunded = data.refundAttributes();
            cmd.sendMessage(sender, RESET, String.valueOf(ChatColor.GOLD) + "{player}'s " + String.valueOf(ChatColor.DARK_GREEN) + "attributes were refunded for attributes " + String.valueOf(ChatColor.GOLD) + "{attributes}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(args[0]), new CustomFilter("attributes", StringUtils.join(refunded, (String)", "))});
            return;
        }
        if (Fabled.getAttributesManager().getAttribute(args[1]) == null) {
            cmd.sendMessage(sender, NOT_ATTR, String.valueOf(ChatColor.GOLD) + "{name}" + String.valueOf(ChatColor.RED) + " is not a valid attribute name", silent, new CustomFilter[]{RPGFilter.NAME.setReplacement(args[1])});
            return;
        }
        if (args.length == 2) {
            boolean success = data.refundAttributeAll(args[1]);
            if (!success) {
                cmd.sendMessage(sender, RESET_ONE_FAIL, String.valueOf(ChatColor.GOLD) + "{player}'s " + String.valueOf(ChatColor.DARK_GREEN) + "{name}" + String.valueOf(ChatColor.RED) + " attributes were not refunded", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(args[0]), RPGFilter.NAME.setReplacement(args[1])});
                return;
            }
            cmd.sendMessage(sender, RESET_ONE, String.valueOf(ChatColor.GOLD) + "{player}'s " + String.valueOf(ChatColor.DARK_GREEN) + "{name}" + String.valueOf(ChatColor.GOLD) + " attributes were refunded", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(args[0]), RPGFilter.NAME.setReplacement(args[1])});
        } else {
            try {
                int amount = Integer.parseInt(args[2]);
                boolean success = data.giveAttribute(args[1], amount);
                if (!success) {
                    cmd.sendMessage(sender, GAVE_ATTR_FAIL, String.valueOf(ChatColor.GOLD) + "{player}" + String.valueOf(ChatColor.RED) + " was not given " + String.valueOf(ChatColor.GOLD) + "{amount} {name} points", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(args[0]), RPGFilter.NAME.setReplacement(args[1])});
                    return;
                }
                cmd.sendMessage(sender, GAVE_ATTR, String.valueOf(ChatColor.GOLD) + "{player}" + String.valueOf(ChatColor.DARK_GREEN) + " was given " + String.valueOf(ChatColor.GOLD) + "{amount} {name} points", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(args[0]), RPGFilter.NAME.setReplacement(args[1]), Filter.AMOUNT.setReplacement("" + amount)});
            }
            catch (Exception ex) {
                cmd.sendMessage(sender, NOT_NUM, String.valueOf(ChatColor.GOLD) + "{amount} " + String.valueOf(ChatColor.RED) + "is not an integer number", silent, new CustomFilter[]{Filter.AMOUNT.setReplacement(args[2])});
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length > 1) {
            return ConfigurableCommand.getTabCompletions(Fabled.getAttributesManager().getKeys(), (String[])Arrays.copyOfRange(args, 1, args.length));
        }
        return null;
    }
}

