/**
 * Fabled
 * studio.magemonkey.fabled.cmd.CmdWorld
 * <p>
 * The MIT License (MIT)
 * <p>
 * Copyright (c) 2024 MageMonkeyStudio
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package studio.magemonkey.fabled.cmd;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;

import java.util.List;
import java.util.stream.Collectors;

public class CmdWorld implements IFunction, TabCompleter {

    private static final String PLAYER_ONLY = "must-be-player";
    private static final String WORLD_NOT_FOUND = "world-not-found";

    @Override
    public void execute(final ConfigurableCommand cmd,
                        final Plugin plugin,
                        final CommandSender sender,
                        final String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            cmd.sendMessage(sender, PLAYER_ONLY, ChatColor.DARK_RED + "Only players can use this command", silent);
            return;
        } else if (args.length < 1) {
            cmd.displayHelp(sender);
            return;
        }

        String worldName = String.join(" ", args);

        World world = Bukkit.getWorld(worldName);
        if (world == null) {
            world = Bukkit.createWorld(new WorldCreator(worldName));
        }

        if (world == null) {
            cmd.sendMessage(sender, WORLD_NOT_FOUND, ChatColor.RED + "World could not be found or created.", silent);
            return;
        }

        ((Player) sender).teleport(world.getSpawnLocation());
        sender.sendMessage(ChatColor.GREEN + "Teleported to world: " + world.getName());
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender,
                                      @NotNull Command command,
                                      @NotNull String s,
                                      @NotNull String[] args) {
        //noinspection Convert2MethodRef
        return ConfigurableCommand.getTabCompletions(Bukkit.getWorlds().stream()
                .map(world -> world.getName())
                .collect(Collectors.toList()), args);
    }
}
