/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.gui.tool;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.gui.tool.GUIData;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.gui.tool.IconHolder;

public abstract class GUIHolder<T extends IconHolder>
implements InventoryHolder {
    protected Map<String, T> data = new HashMap<String, T>();
    protected GUIData gui;
    protected PlayerData player;
    protected Inventory inventory;
    protected int page;

    public void set(GUIData gui, PlayerData player, Inventory inv, Map<String, T> data) {
        this.gui = gui;
        this.player = player;
        this.inventory = inv;
        this.data = data;
        this.onSetup();
    }

    public T get(int slot) {
        String identifier = this.gui.getPage(this.page).get(slot);
        return (T)(identifier == null ? null : (IconHolder)this.data.get(identifier));
    }

    public void next() {
        this.setPage((this.page + 1) % this.gui.getPages());
    }

    public void prev() {
        this.setPage((this.page + this.gui.getPages() - 1) % this.gui.getPages());
    }

    public void setPage(int page) {
        this.page = page;
        ItemStack[] contents = this.gui.getPage(page).instance(this.player, this.data);
        if (this.gui.getPages() > 1) {
            GUITool.addPageButtons(contents);
        }
        this.inventory.setContents(contents);
    }

    public void handleDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Inventory topInv = VersionManager.getCompat().getTopInventory((InventoryEvent)event);
        boolean top = event.getRawSlot() < topInv.getSize();
        T result = this.get(event.getSlot());
        if (top && result != null && result.isAllowed((Player)event.getWhoClicked())) {
            if (event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD || event.getAction() == InventoryAction.HOTBAR_SWAP) {
                this.onHotBar(result, event.getSlot(), event.getHotbarButton());
            } else {
                this.onClick(result, event.getSlot(), event.isLeftClick(), event.isShiftClick());
            }
        } else if (top && this.gui.getPages() > 1) {
            if (this.gui.getSize() == 9) {
                if (event.getSlot() == 7) {
                    this.prev();
                }
                if (event.getSlot() == 8) {
                    this.next();
                }
            } else if (event.getSlot() == 8) {
                this.prev();
            } else if (event.getSlot() == 17) {
                this.next();
            }
        }
    }

    public void handleClose(InventoryCloseEvent event) {
        this.onClose((Player)event.getPlayer());
    }

    protected abstract void onClick(T var1, int var2, boolean var3, boolean var4);

    protected void onHotBar(T type, int from, int to) {
    }

    protected void onSetup() {
    }

    protected void onClose(Player player) {
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

