/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.warp;

import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

abstract class AbstractWarpingMechanic
extends MechanicComponent {
    protected static final String PRESERVE = "preserve";
    protected static final String SET_YAW = "setYaw";
    protected static final String SET_PITCH = "setPitch";
    protected static final String YAW = "yaw";
    protected static final String PITCH = "pitch";

    AbstractWarpingMechanic() {
    }

    public boolean preserveVelocity() {
        return this.settings.getBool(PRESERVE, false);
    }

    public boolean setYaw() {
        return this.settings.getBool(SET_YAW, false);
    }

    public boolean setPitch() {
        return this.settings.getBool(SET_PITCH, false);
    }

    public boolean relativeYaw() {
        return this.settings.getBool("relative-yaw", false);
    }

    public boolean relativePitch() {
        return this.settings.getBool("relative-pitch", false);
    }

    public void warp(LivingEntity target, LivingEntity caster, Location location, int level) {
        boolean relative;
        if (this.setYaw()) {
            relative = this.relativeYaw();
            float yaw = (float)this.parseValues(caster, YAW, level, 0.0);
            if (relative) {
                yaw += target.getLocation().getYaw();
            }
            location.setYaw(yaw);
        }
        if (this.setPitch()) {
            relative = this.relativePitch();
            float pitch = (float)this.parseValues(caster, PITCH, level, 0.0);
            if (relative) {
                pitch += target.getLocation().getPitch();
            }
            location.setPitch(pitch);
        }
        Vector velocity = target.getVelocity().clone();
        boolean marker = false;
        if (target instanceof ArmorStand) {
            marker = ((ArmorStand)target).isMarker();
            ((ArmorStand)target).setMarker(false);
        }
        target.teleport(location);
        if (this.preserveVelocity()) {
            target.setVelocity(velocity);
        }
        if (marker) {
            ((ArmorStand)target).setMarker(true);
        }
    }
}

