/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueRandomMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String INT = "integer";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value random";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty() || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        boolean triangular = this.settings.getString(TYPE).equalsIgnoreCase("triangular");
        CastData data = DynamicSkill.getCastData(caster);
        if (this.settings.getBool(INT, false)) {
            int min = (int)Math.ceil(this.parseValues(caster, MIN, level, 1.0));
            int max = (int)Math.floor(this.parseValues(caster, MAX, level, 1.0));
            if (triangular) {
                int middle = Fabled.RANDOM.nextInt(max - min + 1) + min + Fabled.RANDOM.nextInt(max - min + 1) + min;
                middle = middle / 2 + (middle % 2 == 1 ? (Math.random() < 0.5 ? 1 : 0) : 0);
                data.put(key, middle);
            } else {
                data.put(key, Fabled.RANDOM.nextInt(max - min + 1) + min);
            }
        } else {
            double min = this.parseValues(caster, MIN, level, 1.0);
            double max = this.parseValues(caster, MAX, level, 1.0);
            double rand = triangular ? 0.5 * (Math.random() + Math.random()) : Math.random();
            data.put(key, rand * (max - min) + min);
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

