/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class MineMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String MATERIALS = "materials";
    private static final String DROP = "drop";
    private static final String TOOL = "tool";
    private static final String SHAPE = "shape";
    private static final String RADIUS = "radius";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DEPTH = "depth";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";

    @Override
    public String getKey() {
        return "mine";
    }

    private Location getLocation(LivingEntity caster, int level, LivingEntity target) {
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        Location loc = target.getLocation();
        Vector dir = target.getLocation().getDirection().setY(0).normalize();
        Vector nor = dir.clone().crossProduct(UP);
        loc.add(dir.multiply(forward).add(nor.multiply(right)));
        loc.add(0.0, upward, 0.0);
        return loc;
    }

    private Map<LivingEntity, List<Block>> getAffectedBlocks(LivingEntity caster, int level, List<LivingEntity> targets) {
        boolean sphere = this.settings.getString(SHAPE, "sphere").equalsIgnoreCase("sphere");
        HashSet<String> materials = new HashSet<String>();
        boolean origin = false;
        List<String> materialList = this.settings.getStringList(MATERIALS);
        boolean any = materialList.stream().anyMatch(material -> material.equalsIgnoreCase("any"));
        if (!any) {
            origin = materialList.stream().anyMatch(material -> material.equalsIgnoreCase("origin"));
            for (String material2 : materialList) {
                materials.add(material2.toUpperCase(Locale.US).replace(' ', '_'));
            }
        }
        HashMap<LivingEntity, List<Block>> blockMap = new HashMap<LivingEntity, List<Block>>();
        World w = caster.getWorld();
        if (sphere) {
            double radius = this.parseValues(caster, RADIUS, level, 2.0);
            double rSq = radius * radius;
            for (LivingEntity t : targets) {
                ArrayList<Block> blocks = new ArrayList<Block>();
                blockMap.put(t, blocks);
                Location loc = this.getLocation(caster, level, t);
                double x = loc.getBlockX();
                double y = loc.getBlockY();
                double z = loc.getBlockZ();
                String originMaterial = loc.getBlock().getType().name();
                for (int i = (int)(x - radius) + 1; i < (int)(x + radius); ++i) {
                    for (int j = (int)(y - radius) + 1; j < (int)(y + radius); ++j) {
                        for (int k = (int)(z - radius) + 1; k < (int)(z + radius); ++k) {
                            double dx = x - (double)i;
                            double dy = y - (double)j;
                            double dz = z - (double)k;
                            if (!(dx * dx + dy * dy + dz * dz < rSq)) continue;
                            Block b = w.getBlockAt(i, j, k);
                            Material material3 = b.getType();
                            String materialName = material3.name();
                            if (Fabled.getSettings().getFilteredBlocks().contains(material3) || b.isLiquid() || !any && (!origin || !materialName.equals(originMaterial)) && !materials.contains(materialName)) continue;
                            blocks.add(b);
                        }
                    }
                }
            }
        } else {
            double width = (this.parseValues(caster, WIDTH, level, 5.0) - 1.0) / 2.0;
            double height = (this.parseValues(caster, HEIGHT, level, 5.0) - 1.0) / 2.0;
            double depth = (this.parseValues(caster, DEPTH, level, 5.0) - 1.0) / 2.0;
            for (LivingEntity t : targets) {
                ArrayList<Block> blocks = new ArrayList<Block>();
                blockMap.put(t, blocks);
                Location loc = this.getLocation(caster, level, t);
                double yaw = loc.getYaw();
                boolean facingZ = Math.abs(yaw) < 45.0 || Math.abs(yaw) > 135.0;
                double x = facingZ ? loc.getX() : loc.getZ();
                double y = loc.getY();
                double z = facingZ ? loc.getZ() : loc.getX();
                String originMaterial = loc.getBlock().getType().name();
                for (double i = x - width; i <= x + width + 0.01; i += 1.0) {
                    for (double j = y - height; j <= y + height + 0.01; j += 1.0) {
                        for (double k = z - depth; k <= z + depth + 0.01; k += 1.0) {
                            Block b = w.getBlockAt((int)Math.floor(facingZ ? i : k), (int)Math.floor(j), (int)Math.floor(facingZ ? k : i));
                            Material material4 = b.getType();
                            String materialName = material4.name();
                            if (Fabled.getSettings().getFilteredBlocks().contains(material4) || b.isLiquid() || !any && (!origin || !materialName.equals(originMaterial)) && !materials.contains(materialName)) continue;
                            blocks.add(b);
                        }
                    }
                }
            }
        }
        return blockMap;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Map<LivingEntity, List<Block>> blockMap = this.getAffectedBlocks(caster, level, targets);
        boolean drop = this.settings.getBool(DROP, true);
        boolean success = false;
        if (drop) {
            String toolString = this.settings.getString(TOOL, "CASTER").toUpperCase(Locale.US).replace(' ', '_');
            boolean targetTool = toolString.equals("TARGET");
            ItemStack tool = null;
            if (toolString.equals("CASTER")) {
                EntityEquipment equipment = caster.getEquipment();
                if (equipment != null) {
                    tool = equipment.getItemInMainHand();
                }
            } else if (!targetTool) {
                try {
                    tool = new ItemStack(Material.valueOf((String)toolString));
                }
                catch (IllegalArgumentException equipment) {
                    // empty catch block
                }
            }
            for (Map.Entry entry : blockMap.entrySet()) {
                if (targetTool) {
                    tool = null;
                    EntityEquipment equipment = ((LivingEntity)entry.getKey()).getEquipment();
                    if (equipment != null) {
                        tool = equipment.getItemInMainHand();
                    }
                }
                if (tool == null) {
                    tool = new ItemStack(Material.AIR);
                }
                List blocks = (List)entry.getValue();
                success = success || !blocks.isEmpty();
                for (Block block : blocks) {
                    block.breakNaturally(tool);
                }
            }
        } else {
            for (List<Block> blocks : blockMap.values()) {
                success = success || !blocks.isEmpty();
                Iterator<Block> iterator = blocks.iterator();
                while (iterator.hasNext()) {
                    Block block;
                    BlockData blockData = (block = iterator.next()).getBlockData();
                    block.setType(blockData instanceof Waterlogged && ((Waterlogged)blockData).isWaterlogged() ? Material.WATER : Material.AIR);
                }
            }
        }
        return success;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    if (MineMechanic.this.preview.getBool("per-target-center-only", true)) {
                        for (LivingEntity t : (List)targetSupplier.get()) {
                            ParticleHelper.play(MineMechanic.this.getLocation((LivingEntity)caster, level, t), MineMechanic.this.preview, Set.of(caster), "per-target-", null);
                        }
                    } else {
                        Map<LivingEntity, List<Block>> blockMap = MineMechanic.this.getAffectedBlocks((LivingEntity)caster, level, (List)targetSupplier.get());
                        for (List<Block> blocks : blockMap.values()) {
                            for (Block block : blocks) {
                                ParticleHelper.play(block.getLocation(), MineMechanic.this.preview, Set.of(caster), "per-target-", MineMechanic.this.preview.getBool("per-target-hitbox") ? block.getBoundingBox() : null);
                            }
                        }
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

