/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.sql.tables;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.YAMLParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.data.io.IOManager;
import studio.magemonkey.fabled.data.io.PlayerLoader;
import studio.magemonkey.fabled.data.sql.SQLManager;
import studio.magemonkey.fabled.data.sql.SQLUtils;

public class FabledPlayersSQL
extends IOManager {
    private final String table = "Fabled_players";

    public FabledPlayersSQL() {
        super(Fabled.inst());
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS Fabled_players(uuid varchar(36), data MEDIUMTEXT)");){
            create.execute();
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:FusionPlayersSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlayerAccounts loadPlayerAccounts(OfflinePlayer player) {
        if (player == null) return null;
        if (player.getName() == null) {
            return null;
        }
        try (Connection connection = SQLManager.connection();){
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM Fabled_players WHERE uuid = ?");
            statement.setString(1, player.getUniqueId().toString());
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                PlayerAccounts playerAccounts = SQLUtils.load(player, result.getString("data"));
                return playerAccounts;
            }
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:loadPlayersAccounts] Something went wrong with the sql-connection: " + e.getMessage());
        }
        PlayerAccounts accounts = new PlayerAccounts(player);
        this.saveData(accounts);
        return accounts;
    }

    public Map<UUID, PlayerAccounts> loadAllOnlinePlayerAccounts() {
        HashMap<UUID, PlayerAccounts> result = new HashMap<UUID, PlayerAccounts>();
        StringBuilder bulkSelect = new StringBuilder("SELECT * FROM Fabled_players WHERE uuid IN (");
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        for (int i = 0; i < players.size(); ++i) {
            bulkSelect.append(((Player)players.get(i)).getUniqueId());
            if (i >= Bukkit.getOnlinePlayers().size() - 1) continue;
            bulkSelect.append(",");
        }
        bulkSelect.append(")");
        try (Connection connection = SQLManager.connection();){
            PreparedStatement statement = connection.prepareStatement(bulkSelect.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                PlayerAccounts accounts = SQLUtils.load(Bukkit.getOfflinePlayer((UUID)uuid), resultSet.getString("data"));
                result.put(uuid, accounts);
            }
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:loadAllOnlinePlayerAccounts] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean accountExists(OfflinePlayer player) {
        try (Connection connection = SQLManager.connection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement("SELECT * FROM Fabled_players WHERE uuid = ?");
                try {
                    statement.setString(1, player.getUniqueId().toString());
                    ResultSet result = statement.executeQuery();
                    bl = result.next();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:accountExists] Something went wrong with the sql-connection: " + e.getMessage());
            return false;
        }
    }

    public void savePlayerAccounts(OfflinePlayer player, PlayerAccounts accounts) {
        if (player == null || player.getName() == null) {
            return;
        }
        boolean accountExists = this.accountExists(player);
        String sql = "UPDATE Fabled_players SET data = ? WHERE uuid = ?";
        if (!accountExists) {
            sql = "INSERT INTO Fabled_players (data, uuid) VALUES (?, ?)";
        }
        try (Connection connection = SQLManager.connection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            DataSection data = IOManager.save(accounts);
            if (data == null) {
                Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:savePlayersAccounts] data is null for player: " + player.getName());
                return;
            }
            statement.setString(1, data.toString());
            statement.setString(2, player.getUniqueId().toString());
            statement.execute();
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:savePlayersAccounts] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void saveAllPlayerAccounts() {
        Map<UUID, PlayerAccounts> data = PlayerLoader.getAllPlayerAccounts();
        try (Connection connection = SQLManager.connection();){
            PreparedStatement statement = connection.prepareStatement("UPDATE Fabled_players SET data = ? WHERE uuid = ?");
            for (Map.Entry<UUID, PlayerAccounts> entry : data.entrySet()) {
                UUID uuid = entry.getKey();
                PlayerAccounts accounts = entry.getValue();
                DataSection accountData = IOManager.save(accounts);
                if (accountData == null) {
                    Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:saveAllPlayerAccounts] data is null for UUID: " + String.valueOf(uuid));
                    continue;
                }
                statement.setString(1, accountData.toString());
                statement.setString(2, uuid.toString());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:saveAllPlayerAccounts] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    @Override
    public Map<UUID, PlayerAccounts> loadAll() {
        return this.loadAllOnlinePlayerAccounts();
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        return this.loadPlayerAccounts(player);
    }

    @Override
    public void saveData(PlayerAccounts data) {
        this.savePlayerAccounts(data.getOfflinePlayer(), data);
    }

    @Override
    public void saveAll() {
        this.saveAllPlayerAccounts();
    }

    public int backUpData() {
        int n;
        block9: {
            int count = 0;
            Connection connection = SQLManager.connection();
            try {
                PreparedStatement statement = connection.prepareStatement("SELECT * FROM Fabled_players");
                ResultSet result = statement.executeQuery();
                File file = new File(this.api.getDataFolder(), "players");
                file.mkdir();
                while (result.next()) {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.getString("uuid")));
                    String data = result.getString("data");
                    String yaml = new YAMLParser().parseText(data).toString();
                    FileOutputStream out = new FileOutputStream(new File(file, String.valueOf(player.getUniqueId()) + ".yml"));
                    BufferedWriter write = new BufferedWriter(new OutputStreamWriter(out));
                    write.write(yaml);
                    write.close();
                    ++count;
                }
                n = count;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    Fabled.inst().getLogger().warning("&4SQL database backup failed - backed up {amount} entries" + String.valueOf(Filter.AMOUNT.setReplacement("" + count)));
                    Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:backUpdata] Something went wrong with the sql-connection: " + e.getMessage());
                    return count;
                }
            }
            connection.close();
        }
        return n;
    }

    public void migrateTable() {
        block16: {
            try {
                if (this.columnExists("id")) {
                    try (PreparedStatement delete = SQLManager.connection().prepareStatement("ALTER TABLE Fabled_players DROP COLUMN id");){
                        delete.execute();
                    }
                }
                if (!this.columnExists("Name")) break block16;
                try (PreparedStatement rename = SQLManager.connection().prepareStatement("ALTER TABLE Fabled_players CHANGE Name uuid varchar(36) PRIMARY KEY");){
                    rename.execute();
                }
            }
            catch (SQLException e) {
                Fabled.inst().getLogger().warning("[SQL:FusionPlayersSQL:migrateTable] Something went wrong with the SQL connection: " + e.getMessage());
            }
        }
    }

    private boolean columnExists(String columnName) throws SQLException {
        try (PreparedStatement stmt = SQLManager.connection().prepareStatement("SHOW COLUMNS FROM Fabled_players LIKE ?");){
            boolean bl;
            block12: {
                stmt.setString(1, columnName);
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

