/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;

public class CmdWorld
implements IFunction,
TabCompleter {
    private static final String PLAYER_ONLY = "must-be-player";
    private static final String WORLD_NOT_FOUND = "world-not-found";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            cmd.sendMessage(sender, PLAYER_ONLY, String.valueOf(ChatColor.DARK_RED) + "Only players can use this command", silent, new CustomFilter[0]);
            return;
        }
        if (args.length < 1) {
            cmd.displayHelp(sender);
            return;
        }
        String worldName = String.join((CharSequence)" ", args);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            world = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName));
        }
        if (world == null) {
            cmd.sendMessage(sender, WORLD_NOT_FOUND, String.valueOf(ChatColor.RED) + "World could not be found or created.", silent, new CustomFilter[0]);
            return;
        }
        ((Player)sender).teleport(world.getSpawnLocation());
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to world: " + world.getName());
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        return ConfigurableCommand.getTabCompletions((Collection)Bukkit.getWorlds().stream().map(world -> world.getName()).collect(Collectors.toList()), (String[])args);
    }
}

