/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.target;

import com.google.common.base.Objects;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class AABB {
    private Vec3D max;
    private Vec3D min;

    public AABB(Vec3D min, Vec3D max) {
        this.min = min;
        this.max = max;
    }

    public AABB(Location block) {
        this(Vec3D.fromLocation(block), Vec3D.fromLocation(block).add(Vec3D.UNIT_MAX));
    }

    public Vec3D getMax() {
        return this.max;
    }

    public Vec3D getMin() {
        return this.min;
    }

    public void expand(double expand) {
        this.min = this.min.add(new Vec3D(-expand, -expand, -expand));
        this.max = this.max.add(new Vec3D(expand, expand, expand));
    }

    public Vec3D intersectsRay(Ray3D ray, float minDist, double maxDist) {
        Vec3D invDir = new Vec3D(1.0 / ray.dir.x, 1.0 / ray.dir.y, 1.0 / ray.dir.z);
        boolean signDirX = invDir.x < 0.0;
        boolean signDirY = invDir.y < 0.0;
        boolean signDirZ = invDir.z < 0.0;
        Vec3D bbox = signDirX ? this.max : this.min;
        double tmin = (bbox.x - ray.x) * invDir.x;
        bbox = signDirX ? this.min : this.max;
        double tmax = (bbox.x - ray.x) * invDir.x;
        bbox = signDirY ? this.max : this.min;
        double tymin = (bbox.y - ray.y) * invDir.y;
        bbox = signDirY ? this.min : this.max;
        double tymax = (bbox.y - ray.y) * invDir.y;
        if (tmin > tymax || tymin > tmax) {
            return null;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        bbox = signDirZ ? this.max : this.min;
        double tzmin = (bbox.z - ray.z) * invDir.z;
        bbox = signDirZ ? this.min : this.max;
        double tzmax = (bbox.z - ray.z) * invDir.z;
        if (tmin > tzmax || tzmin > tmax) {
            return null;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        if (tmin < maxDist && tmax > (double)minDist) {
            return ray.getPointAtDistance(tmin);
        }
        return null;
    }

    public static class Vec3D {
        public static final Vec3D UNIT_MAX = new Vec3D(1.0, 1.0, 1.0);
        public final double x;
        public final double y;
        public final double z;

        public Vec3D(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec3D(Vec3D v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }

        public static Vec3D fromLocation(Location loc) {
            return new Vec3D(loc.getX(), loc.getY(), loc.getZ());
        }

        public static Vec3D fromVector(Vector v) {
            return new Vec3D(v.getX(), v.getY(), v.getZ());
        }

        public final Vec3D add(Vec3D v) {
            return new Vec3D(this.x + v.x, this.y + v.y, this.z + v.z);
        }

        public Vec3D scale(double s) {
            return new Vec3D(this.x * s, this.y * s, this.z * s);
        }

        public Vec3D normalize() {
            double mag = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            if (mag > 0.0) {
                return this.scale(1.0 / mag);
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Vec3D) {
                Vec3D v = (Vec3D)obj;
                return this.x == v.x && this.y == v.y && this.z == v.z;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
        }

        public String toString() {
            return String.format("{x: %g, y: %g, z: %g}", this.x, this.y, this.z);
        }
    }

    public static class Ray3D
    extends Vec3D {
        public final Vec3D dir;

        public Ray3D(Vec3D origin, Vec3D direction) {
            super(origin);
            this.dir = direction.normalize();
        }

        public Ray3D(Location loc) {
            this(Vec3D.fromLocation(loc), Vec3D.fromVector(loc.getDirection()));
        }

        public Vec3D getDirection() {
            return this.dir;
        }

        public Vec3D getPointAtDistance(double dist) {
            return this.add(this.dir.scale(dist));
        }

        @Override
        public String toString() {
            return "origin: " + super.toString() + " dir: " + String.valueOf(this.dir);
        }
    }
}

