/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.util.eval.Evaluator;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueMathMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String FUNCTION = "function";
    private static final String SAVE = "save";
    private static final Pattern placeholderPattern = Pattern.compile("\\{([^}]+)}");

    @Override
    public String getKey() {
        return "value math";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        double amount;
        if (targets.isEmpty() || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        String func = this.filter(caster, targets.get(0), this.settings.getString(FUNCTION));
        CastData data = DynamicSkill.getCastData(caster);
        if (placeholderPattern.matcher(func).find()) {
            Fabled.inst().getLogger().warning("Invalid math function: \"" + func + "\", contains unresolved placeholders. We'll help you out and replace them with 0.");
            func = placeholderPattern.matcher(func).replaceAll("0");
        }
        if (Double.isInfinite(amount = Evaluator.eval((String)func, (int)1)) || Double.isNaN(amount)) {
            Fabled.inst().getLogger().warning("Invalid math function: \"" + func + "\", produced: " + amount);
            return false;
        }
        data.put(key, amount);
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

