/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.EffectPlayer;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.particle.target.FollowTarget;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ParticleProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.util.VectorUtil;

public class ParticleProjectileMechanic
extends MechanicComponent
implements ProjectileCallback {
    private static final String GROUP = "group";
    private static final String LIFESPAN = "lifespan";
    private static final String DISTANCE = "distance";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    private final List<UUID> hitEntities = new ArrayList<UUID>();

    @Override
    public String getKey() {
        return "particle projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        boolean ally = this.settings.getString(GROUP, "enemy").equalsIgnoreCase("ally");
        this.settings.set("level", level);
        int life = (int)(this.parseValues(caster, LIFESPAN, level, this.settings.getDouble(LIFESPAN, 2.0)) * 20.0);
        int distance = (int)this.parseValues(caster, DISTANCE, level, this.settings.getDouble(DISTANCE, 2.0));
        Settings copy = new Settings(this.settings);
        copy.set("collision-radius", this.parseValues(caster, "collision-radius", level, 1.5), 0.0);
        copy.set("gravity", this.parseValues(caster, "gravity", level, -0.04), 0.0);
        copy.set("drag", this.parseValues(caster, "drag", level, 0.02), 0.0);
        copy.set("velocity", this.parseValues(caster, "velocity", level, 1.0), 0.0);
        copy.set("homing-distance", this.parseValues(caster, "homing-distance", level, 20.0), 0.0);
        copy.set("correction", this.parseValues(caster, "correction", level, 0.2), 0.0);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        for (LivingEntity target : targets) {
            List<ParticleProjectile> list;
            Location location = VectorUtil.getOffsetLocation(target, this.parseValues(caster, FORWARD, level, 0.0), this.parseValues(caster, RIGHT, level, 0.0), this.parseValues(caster, UPWARD, level, 0.0));
            if (spread.equals("rain")) {
                list = ParticleProjectile.rain(caster, level, location, copy, this.parseValues(caster, RADIUS, level, 2.0), this.parseValues(caster, HEIGHT, level, 8.0), amount, this, life, distance);
            } else {
                Vector dir = location.getDirection();
                if (spread.equals("horizontal cone")) {
                    dir.setY(0);
                    dir.normalize();
                }
                list = ParticleProjectile.spread(caster, level, dir, location, copy, this.parseValues(caster, ANGLE, level, 30.0), amount, this, life, distance);
            }
            for (ParticleProjectile p : list) {
                Fabled.setMeta(p, LEVEL, level);
                p.setAllyEnemy(ally, !ally);
            }
            if (!this.settings.getBool(USE_EFFECT, false)) continue;
            EffectPlayer player = new EffectPlayer(this.settings);
            for (CustomProjectile customProjectile : list) {
                player.start(new FollowTarget(customProjectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), life, level, true);
            }
        }
        return !targets.isEmpty();
    }

    @Override
    public void callback(CustomProjectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        if (this.hitEntities.contains(hit.getUniqueId())) {
            return;
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(hit);
        this.executeChildren(projectile.getShooter(), Fabled.getMetaInt(projectile, LEVEL), targets, this.skill.isForced(projectile.getShooter()));
        this.hitEntities.add(hit.getUniqueId());
        LivingEntity finalHit = hit;
        Bukkit.getScheduler().runTaskLater((Plugin)Fabled.inst(), () -> this.hitEntities.remove(finalHit.getUniqueId()), 2L);
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        final ArrayList targets = new ArrayList();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                targets.clear();
                int amount = (int)ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.AMOUNT, level, 1.0);
                String spread = ParticleProjectileMechanic.this.settings.getString(ParticleProjectileMechanic.SPREAD, "cone").toLowerCase();
                boolean ally = ParticleProjectileMechanic.this.settings.getString(ParticleProjectileMechanic.GROUP, "enemy").equalsIgnoreCase("ally");
                int life = (int)(ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.LIFESPAN, level, ParticleProjectileMechanic.this.settings.getDouble(ParticleProjectileMechanic.LIFESPAN, 2.0)) * 20.0);
                int distance = (int)ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.DISTANCE, level, ParticleProjectileMechanic.this.settings.getInt(ParticleProjectileMechanic.DISTANCE, 2));
                Settings copy = new Settings(ParticleProjectileMechanic.this.settings);
                copy.set("collision-radius", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "collision-radius", level, 1.5));
                copy.set("gravity", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "gravity", level, -0.04), 0.0);
                copy.set("drag", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "drag", level, 0.02), 0.0);
                copy.set("velocity", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "velocity", level, 1.0), 0.0);
                copy.set("period", ParticleProjectileMechanic.this.preview.getInt("path-steps", 2));
                copy.set("homing-distance", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "homing-distance", level, 20.0), 0.0);
                copy.set("correction", ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, "correction", level, 0.2), 0.0);
                ProjectileCallback callback = (projectile, hit) -> {
                    if (hit == null) {
                        hit = new TempEntity(projectile.getLocation());
                    }
                    targets.add(hit);
                    if (ParticleProjectileMechanic.this.preview.getBool("per-target")) {
                        ParticleHelper.play(hit.getLocation(), ParticleProjectileMechanic.this.preview, Set.of(caster), "per-target-", ParticleProjectileMechanic.this.preview.getBool("per-target-hitbox") ? hit.getBoundingBox() : null);
                    }
                };
                ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
                for (LivingEntity target : (List)targetSupplier.get()) {
                    Location location = VectorUtil.getOffsetLocation(target, ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.FORWARD, level, 0.0), ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.RIGHT, level, 0.0), ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.UPWARD, level, 0.0));
                    if (spread.equals("rain")) {
                        list.addAll(ParticleProjectile.rain((LivingEntity)caster, level, location, copy, ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.RADIUS, level, 2.0), ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.HEIGHT, level, 8.0), amount, callback, life, distance));
                    } else {
                        Vector dir = location.getDirection();
                        if (spread.equals("horizontal cone")) {
                            dir.setY(0);
                            dir.normalize();
                        }
                        list.addAll(ParticleProjectile.spread((LivingEntity)caster, level, dir, location, copy, ParticleProjectileMechanic.this.parseValues((LivingEntity)caster, ParticleProjectileMechanic.ANGLE, level, 30.0), amount, callback, life, distance));
                    }
                    for (ParticleProjectile p : list) {
                        Fabled.setMeta(p, ParticleProjectileMechanic.LEVEL, level);
                        p.setAllyEnemy(ally, !ally);
                    }
                    Consumer<Location> onStep = ParticleProjectileMechanic.this.preview.getBool("path") ? loc -> new ParticleSettings(ParticleProjectileMechanic.this.preview, "path-").instance(caster, loc.getX(), loc.getY(), loc.getZ()) : loc -> {};
                    for (ParticleProjectile p : list) {
                        p.setOnStep(onStep);
                    }
                    for (ParticleProjectile p : list) {
                        while (p.isValid()) {
                            p.run();
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("period", 5)));
        onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        this.playChildrenPreviews(onPreviewStop, caster, level, () -> targets);
    }
}

