/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.particle;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ParticleAnimationMechanic
extends MechanicComponent {
    public static final String WITH_ROTATION = "-with-rotation";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String STEPS = "steps";
    private static final String FREQ = "frequency";
    private static final String ANGLE = "angle";
    private static final String START = "start";
    private static final String DURATION = "duration";
    private static final String H_TRANS = "h-translation";
    private static final String V_TRANS = "v-translation";
    private static final String H_CYCLES = "h-cycles";
    private static final String V_CYCLES = "v-cycles";

    @Override
    public String getKey() {
        return "particle animation";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Settings copy = new Settings(this.settings);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        copy.set("level", level);
        new ParticleTask(caster, targets, level, copy);
        return !targets.isEmpty();
    }

    private class ParticleTask
    extends BukkitRunnable {
        private final List<LivingEntity> targets;
        private final double[] rots;
        private final Vector offset;
        private final Vector dir;
        private final double upward;
        private final int steps;
        private final int duration;
        private final int hl;
        private final int vl;
        private final double ht;
        private final double vt;
        private final double cos;
        private final Settings settings;
        private final double sin;
        private final boolean withRotation;
        private int life;

        ParticleTask(LivingEntity caster, List<LivingEntity> targets, int level, Settings settings) {
            this.targets = targets;
            this.settings = settings;
            double forward = ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.FORWARD, 0.0);
            this.upward = ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.UPWARD, 0.0);
            double right = ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.RIGHT, 0.0);
            this.steps = (int)ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.STEPS, 1.0);
            int freq = (int)(ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.FREQ, 1.0) * 20.0);
            int angle = (int)ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.ANGLE, 0.0);
            int startAngle = (int)ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.START, 0.0);
            this.duration = this.steps * (int)(20.0 * ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.DURATION, level, 3.0));
            this.life = 0;
            this.ht = ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.H_TRANS, level, 0.0);
            this.vt = ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.V_TRANS, level, 0.0);
            int hc = (int)ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.H_CYCLES, 1.0);
            int vc = (int)ParticleAnimationMechanic.this.getNum(caster, ParticleAnimationMechanic.V_CYCLES, 1.0);
            this.hl = this.duration / hc;
            this.vl = this.duration / vc;
            this.withRotation = settings.getBool(ParticleAnimationMechanic.WITH_ROTATION);
            this.cos = Math.cos((double)angle * Math.PI / (double)(180 * this.duration));
            this.sin = Math.sin((double)angle * Math.PI / (double)(180 * this.duration));
            this.rots = new double[targets.size()];
            for (int i = 0; i < targets.size(); ++i) {
                this.rots[i] = targets.get(i).getLocation().getYaw();
            }
            this.dir = new Vector(0, 0, 1);
            this.offset = new Vector(right, this.upward, forward);
            double sc = Math.cos(Math.toRadians(startAngle));
            double ss = Math.sin(Math.toRadians(startAngle));
            this.rotate(this.offset, sc, ss);
            this.rotate(this.dir, sc, ss);
            Fabled.schedule(this, 0, freq);
        }

        public void run() {
            for (int i = 0; i < this.steps; ++i) {
                int j = 0;
                for (LivingEntity target : this.targets) {
                    Location loc = target.getLocation();
                    double targetAngle = loc.getYaw();
                    if (this.withRotation) {
                        double targetCos = Math.cos(Math.toRadians(targetAngle));
                        double targetSin = Math.sin(Math.toRadians(targetAngle));
                        this.rotate(this.offset, targetCos, targetSin);
                        loc.add(this.offset);
                        ParticleHelper.play(loc, this.settings);
                        loc.subtract(this.offset);
                        targetCos = Math.cos(Math.toRadians(-targetAngle));
                        targetSin = Math.sin(Math.toRadians(-targetAngle));
                        this.rotate(this.offset, targetCos, targetSin);
                        continue;
                    }
                    this.rotate(this.offset, Math.cos(Math.toRadians(this.rots[j])), Math.sin(Math.toRadians(this.rots[j])));
                    loc.add(this.offset);
                    ParticleHelper.play(loc, this.settings);
                    loc.subtract(this.offset);
                    this.rotate(this.offset, Math.cos(Math.toRadians(-this.rots[j])), Math.sin(Math.toRadians(-this.rots[j])));
                    ++j;
                }
                ++this.life;
                this.rotate(this.offset, this.cos, this.sin);
                this.rotate(this.dir, this.cos, this.sin);
                double dx = this.radAt(this.life) - this.radAt(this.life - 1);
                this.offset.setX(this.offset.getX() + dx * this.dir.getX());
                this.offset.setZ(this.offset.getZ() + dx * this.dir.getZ());
                this.offset.setY(this.upward + this.heightAt(this.life));
            }
            if (this.life >= this.duration) {
                this.cancel();
            }
        }

        private double heightAt(int step) {
            return this.vt * (double)(this.vl - Math.abs(this.vl - step % (2 * this.vl))) / (double)this.vl;
        }

        private double radAt(int step) {
            return this.ht * (double)(this.hl - Math.abs(this.hl - step % (2 * this.hl))) / (double)this.hl;
        }

        private void rotate(Vector vec, double cos, double sin) {
            double x = vec.getX() * cos - vec.getZ() * sin;
            vec.setZ(vec.getX() * sin + vec.getZ() * cos);
            vec.setX(x);
        }
    }
}

