/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Collection;
import java.util.Locale;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class PotionCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String POTION = "potion";
    private static final String MIN_RANK = "min-rank";
    private static final String MAX_RANK = "max-rank";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        boolean active = !this.settings.getString(TYPE, "active").equalsIgnoreCase("not active");
        Collection effects = target.getActivePotionEffects();
        if (effects.isEmpty()) {
            return !active;
        }
        String potion = this.settings.getString(POTION, "").toUpperCase(Locale.US).replace(' ', '_');
        int minRank = (int)this.parseValues(caster, MIN_RANK, level, 0.0);
        int maxRank = (int)this.parseValues(caster, MAX_RANK, level, 999.0);
        try {
            PotionEffectType type = PotionEffectType.getByName((String)potion);
            return this.has(target, type, minRank, maxRank) == active;
        }
        catch (Exception ex) {
            for (PotionEffect check : effects) {
                if (check.getAmplifier() < minRank || check.getAmplifier() > maxRank) continue;
                return true;
            }
            return false;
        }
    }

    private boolean has(LivingEntity target, PotionEffectType type, int min, int max) {
        if (!target.hasPotionEffect(type)) {
            return false;
        }
        int rank = target.getPotionEffect(type).getAmplifier();
        return rank >= min && rank <= max;
    }

    @Override
    public String getKey() {
        return POTION;
    }
}

