/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkillBar;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.Combat;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.hook.CitizensHook;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdChangeClass
implements IFunction,
TabCompleter {
    private static final String INVALID_GROUP = "invalid-group";
    private static final String INVALID_PLAYER = "invalid-player";
    private static final String INVALID_TARGET = "invalid-class";
    private static final String SUCCESS = "success";
    private static final String NOTIFICATION = "notification";

    public static void unload(Player player) {
        if (CitizensHook.isNPC((Entity)player)) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            data.record(player);
            data.stopSkills(player);
        }
        FlagManager.clearFlags((LivingEntity)player);
        BuffManager.clearData((LivingEntity)player);
        Combat.clearData(player);
        DynamicSkill.clearCastData((LivingEntity)player);
        player.setDisplayName(player.getName());
        player.setWalkSpeed(0.2f);
    }

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        boolean bar;
        if (args.length < 3) {
            cmd.displayHelp(sender);
            return;
        }
        String playerName = args[0];
        String groupName = args[1];
        StringBuilder className = new StringBuilder(args[2]);
        for (int i = 3; i < args.length; ++i) {
            className.append(' ').append(args[i]);
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null && !(player = Bukkit.getOfflinePlayer((String)playerName)).hasPlayedBefore()) {
            cmd.sendMessage(sender, INVALID_PLAYER, String.valueOf(ChatColor.DARK_RED) + "{player} is not online, nor have they played before.", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(playerName)});
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        PlayerClass clazz = data.getClass(groupName);
        if (clazz == null) {
            cmd.sendMessage(sender, INVALID_GROUP, "{player} does not have a {class}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement(className.toString())});
            return;
        }
        String original = clazz.getData().getName();
        FabledClass target = Fabled.getClass(className.toString());
        if (target == null) {
            cmd.sendMessage(sender, INVALID_TARGET, "{class} is not a valid class to change to", silent, new CustomFilter[]{RPGFilter.CLASS.setReplacement(className.toString())});
            return;
        }
        boolean bl = bar = data.getSkillBar().isEnabled() && Fabled.getSettings().isSkillBarEnabled();
        if (bar) {
            PlayerSkillBar skillBar = data.getSkillBar();
            skillBar.toggleEnabled();
            skillBar.reset();
            data.getSkillBar().toggleEnabled();
        }
        if (player.isOnline()) {
            CmdChangeClass.unload(player);
            clazz.setClassData(target);
            Fabled.getPlayerAccounts((OfflinePlayer)player).getActiveData().init(player);
        } else {
            clazz.setClassData(target);
        }
        if (bar) {
            Fabled.getData((OfflinePlayer)player).getSkillBar().toggleEnabled();
        }
        cmd.sendMessage(sender, SUCCESS, "You have changed {player} from a {name} to a {class}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement(className.toString()), RPGFilter.NAME.setReplacement(original)});
        if (sender != player && player.isOnline()) {
            cmd.sendMessage((CommandSender)player, NOTIFICATION, "You have changed from a {name} to a {class}", silent, new CustomFilter[]{RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement(className.toString()), RPGFilter.NAME.setReplacement(original)});
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length > 1) {
            CharSequence[] group = Arrays.copyOfRange(args, 1, 2);
            for (int i = 3; i <= args.length; ++i) {
                CharSequence[] concat = Arrays.copyOfRange(args, 1, i);
                String g = String.join((CharSequence)" ", concat);
                if (Fabled.getGroups().stream().noneMatch(g1 -> StringUtil.startsWithIgnoreCase((String)g1, (String)g))) {
                    String finalGroup = String.join((CharSequence)" ", group);
                    return ConfigurableCommand.getTabCompletions((Collection)Fabled.getClasses().values().stream().filter(rpgClass -> rpgClass.getGroup().equalsIgnoreCase(finalGroup)).map(FabledClass::getName).collect(Collectors.toList()), (String[])Arrays.copyOfRange(args, i - 1, args.length));
                }
                group = concat;
            }
            return ConfigurableCommand.getTabCompletions(Fabled.getGroups(), (String[])group);
        }
        return null;
    }
}

