/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.armorstand;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.armorstand.ArmorStandData;
import studio.magemonkey.fabled.api.armorstand.ArmorStandInstance;
import studio.magemonkey.fabled.task.ArmorStandTask;
import studio.magemonkey.fabled.thread.MainThread;

public class ArmorStandManager {
    private static final Map<LivingEntity, ArmorStandData> instances = new ConcurrentHashMap<LivingEntity, ArmorStandData>();

    public static void init() {
        MainThread.register(new ArmorStandTask());
        Bukkit.getWorlds().forEach(world -> world.getEntitiesByClass(ArmorStand.class).forEach(as -> {
            if (Fabled.getMeta((Metadatable)as, "asMechanic") != null) {
                as.remove();
            }
        }));
    }

    public static void cleanUp() {
        instances.values().forEach(ArmorStandData::remove);
        instances.clear();
    }

    public static void clear(LivingEntity target) {
        instances.remove(target);
    }

    public static ArmorStandData getArmorStandData(LivingEntity target) {
        return instances.get(target);
    }

    public static Optional<ArmorStandInstance> getArmorStand(LivingEntity target, String key) {
        if (!instances.containsKey(target)) {
            return Optional.empty();
        }
        return Optional.ofNullable(instances.get(target).getArmorStands(key));
    }

    public static void register(ArmorStandInstance armorStand, LivingEntity target, String key) {
        if (!instances.containsKey(target)) {
            instances.put(target, new ArmorStandData(target));
        }
        instances.get(target).register(armorStand, key);
    }

    public static void tick() {
        Iterator<ArmorStandData> iterator = instances.values().iterator();
        while (iterator.hasNext()) {
            ArmorStandData data = iterator.next();
            if (data.isValid()) {
                data.tick();
                continue;
            }
            data.remove();
            iterator.remove();
        }
    }
}

