/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.warp;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.mechanic.warp.AbstractWarpingMechanic;

public class WarpLocMechanic
extends AbstractWarpingMechanic {
    private static final String WORLD = "world";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";

    @Override
    public String getKey() {
        return "warp location";
    }

    @Override
    public boolean setYaw() {
        return true;
    }

    @Override
    public boolean setPitch() {
        return true;
    }

    @Nullable
    private Location parseLocation(LivingEntity caster) {
        World w;
        String world = this.settings.getString(WORLD, "current");
        if (world.equalsIgnoreCase("current")) {
            world = caster.getWorld().getName();
        }
        if ((w = Bukkit.getWorld((String)world)) == null) {
            return null;
        }
        double x = this.settings.getDouble(X, 0.0);
        double y = this.settings.getDouble(Y, 0.0);
        double z = this.settings.getDouble(Z, 0.0);
        return new Location(w, x, y, z);
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Location loc = this.parseLocation(caster);
        if (loc == null) {
            return false;
        }
        for (LivingEntity target : targets) {
            this.warp(target, caster, loc, level);
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target") && !targetSupplier.get().isEmpty()) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    Location loc = WarpLocMechanic.this.parseLocation((LivingEntity)caster);
                    if (loc == null) {
                        return;
                    }
                    ParticleHelper.play(loc, WarpLocMechanic.this.preview, Set.of(caster), "per-target-", null);
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

