/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.shield;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.items.PrefixHelper;
import studio.magemonkey.codex.registry.provider.BuffProvider;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.shield.ShieldDetails;
import studio.magemonkey.fabled.shield.ShieldEffect;

public class ShieldManager
implements BuffProvider {
    private final Fabled plugin;
    private final Map<UUID, ShieldDetails> shieldDetails = new HashMap<UUID, ShieldDetails>();

    @Nullable
    public ShieldDetails getShieldDetails(@NotNull LivingEntity entity) {
        return this.shieldDetails.get(entity.getUniqueId());
    }

    public void setShieldDetails(@NotNull LivingEntity entity, @NotNull ShieldDetails details) {
        this.shieldDetails.put(entity.getUniqueId(), details);
    }

    public void removeShieldDetails(LivingEntity entity) {
        ShieldDetails details = this.shieldDetails.remove(entity.getUniqueId());
        if (details != null) {
            details.clearEffects();
        }
    }

    public void clearShields() {
        this.shieldDetails.values().forEach(ShieldDetails::clearEffects);
        this.shieldDetails.clear();
    }

    public boolean hasShield(@NotNull LivingEntity entity) {
        return this.shieldDetails.containsKey(entity.getUniqueId());
    }

    public void addEffect(@NotNull LivingEntity entity, @NotNull ShieldEffect effect, int ticks) {
        UUID uuid = entity.getUniqueId();
        ShieldDetails details = this.shieldDetails.computeIfAbsent(uuid, ShieldDetails::new);
        details.addEffect(effect, ticks);
        this.displayShieldDetails(entity);
    }

    public void displayShieldDetails(@NotNull LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        ShieldDetails details = this.getShieldDetails(entity);
        if (details == null) {
            return;
        }
        if (details.getDisplayTask() != null && !details.getDisplayTask().isCancelled()) {
            return;
        }
        details.setDisplayTask(this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!entity.isValid()) {
                details.getDisplayTask().cancel();
                return;
            }
            if (!details.hasEffects()) {
                details.getDisplayTask().cancel();
            }
            for (ShieldEffect effect : details.getActiveEffects()) {
                effect.display((Player)entity);
            }
        }, 0L, 20L));
    }

    public double scaleValue(String identifier, @NotNull LivingEntity entity, double value) {
        identifier = PrefixHelper.stripPrefix((String)"FABLED", (String)identifier);
        ShieldDetails details = this.getShieldDetails(entity);
        if (details == null) {
            return value;
        }
        double scaled = value;
        for (ShieldEffect effect : details.getActiveEffects()) {
            if (!effect.getClassifier().equals(identifier)) continue;
            scaled = effect.damageAndDisplay(scaled, entity);
        }
        return scaled;
    }

    public double scaleDamageForDefense(String identifier, @NotNull LivingEntity entity, double damage) {
        identifier = PrefixHelper.stripPrefix((String)"FABLED", (String)identifier);
        ShieldDetails details = this.getShieldDetails(entity);
        if (details == null) {
            return damage;
        }
        double actualDamage = damage;
        for (ShieldEffect effect : details.getActiveEffects()) {
            if (!effect.getClassifier().equals(identifier)) continue;
            actualDamage = effect.damageAndDisplay(actualDamage, entity);
        }
        return actualDamage;
    }

    @Generated
    public ShieldManager(Fabled plugin) {
        this.plugin = plugin;
    }
}

