/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.shield;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.shield.ShieldEffect;

public class ShieldDetails {
    private final UUID uniqueId;
    private final List<ShieldEffect> effects = new ArrayList<ShieldEffect>();
    private BukkitTask displayTask;

    public ShieldDetails(LivingEntity entity) {
        this.uniqueId = entity.getUniqueId();
    }

    public LivingEntity getEntity() {
        return (LivingEntity)Bukkit.getEntity((UUID)this.uniqueId);
    }

    public void addEffect(ShieldEffect effect, int ticks) {
        this.effects.add(effect);
        effect.setTask(Fabled.schedule(new ShieldTask(effect), ticks));
    }

    public void removeEffect(ShieldEffect effect) {
        effect.destroy();
        this.effects.remove(effect);
    }

    public void removeEffect(String classifier) {
        this.effects.removeIf(effect -> {
            if (effect.getClassifier().equals(classifier)) {
                effect.destroy();
                return true;
            }
            return false;
        });
    }

    public ShieldEffect getEffect(String classifier) {
        this.update();
        return this.effects.stream().filter(effect -> effect.getClassifier().equals(classifier)).findFirst().orElse(null);
    }

    public boolean hasEffect(String classifier) {
        this.update();
        return this.effects.stream().anyMatch(effect -> effect.getClassifier().equals(classifier));
    }

    public void clearEffects() {
        this.effects.forEach(ShieldEffect::destroy);
        this.effects.clear();
        this.displayTask.cancel();
        this.displayTask = null;
    }

    public boolean hasEffects() {
        this.update();
        return !this.effects.isEmpty();
    }

    public List<ShieldEffect> getActiveEffects() {
        this.update();
        return this.effects;
    }

    public void update() {
        this.effects.removeIf(shieldEffect -> {
            if (shieldEffect.isExhausted()) {
                if (this.getEntity() instanceof Player) {
                    shieldEffect.display((Player)this.getEntity());
                }
                shieldEffect.destroy();
                return true;
            }
            return false;
        });
    }

    @Generated
    public ShieldDetails(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public BukkitTask getDisplayTask() {
        return this.displayTask;
    }

    @Generated
    public void setDisplayTask(BukkitTask displayTask) {
        this.displayTask = displayTask;
    }

    private class ShieldTask
    implements Runnable {
        private final ShieldEffect effect;

        @Override
        public void run() {
            if (!ShieldDetails.this.getEntity().isValid()) {
                Fabled.inst().getShieldManager().removeShieldDetails(ShieldDetails.this.getEntity());
                return;
            }
            ShieldDetails.this.removeEffect(this.effect);
        }

        @Generated
        public ShieldTask(ShieldEffect effect) {
            this.effect = effect;
        }
    }
}

