/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.PlayerClassChangeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillDowngradeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillUnlockEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.cast.PlayerCastWheel;
import studio.magemonkey.fabled.hook.PlaceholderAPIHook;
import studio.magemonkey.fabled.hook.PluginChecker;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class CastWheelListener
extends FabledListener {
    private boolean enabled = true;
    private final Map<UUID, Long> dropPlayers = new HashMap<UUID, Long>();

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        Bukkit.getOnlinePlayers().forEach(this::init);
    }

    @Override
    public void cleanup() {
        Bukkit.getOnlinePlayers().stream().filter(player -> Fabled.getSettings().isWorldEnabled(player.getWorld())).forEach(this::init);
        this.enabled = false;
    }

    private void init(Player player) {
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        data.getCastWheel().validate(data);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangeWorldPre(PlayerChangedWorldEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld()) && Fabled.getSettings().isWorldEnabled(event.getFrom())) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler
    public void onClassChange(PlayerClassChangeEvent event) {
        PlayerData data = event.getPlayerData();
        event.getPlayerData().getCastWheel().validate(data);
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        event.getPlayerData().getCastWheel().unlock(event.getUnlockedSkill());
    }

    @EventHandler
    public void onDowngrade(PlayerSkillDowngradeEvent event) {
        PlayerData data = event.getPlayerData();
        PlayerSkill skill = event.getDowngradedSkill();
        if (skill.getLevel() == 1) {
            data.getCastWheel().remove(skill);
        }
    }

    @EventHandler
    public void onHandSwap(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (Fabled.getSettings().isWheelSneakToOffhand() && player.isSneaking()) {
            return;
        }
        event.setCancelled(true);
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        if (castWheel.isCasting()) {
            castWheel.setCasting(false);
            player.playSound(player.getLocation(), Fabled.getSettings().getWheelSoundsStopCasting(), (float)Fabled.getSettings().getWheelSoundsVolume(), 1.0f);
        } else if (!castWheel.isEmpty()) {
            player.playSound(player.getLocation(), Fabled.getSettings().getWheelSoundsStartCasting(), (float)Fabled.getSettings().getWheelSoundsVolume(), 1.0f);
            castWheel.setCasting(true);
            new CastWheelTask(playerData).runTaskTimer((Plugin)Fabled.inst(), 0L, 1L);
        }
    }

    @EventHandler
    public void onHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        if (!castWheel.isCasting()) {
            return;
        }
        if (Fabled.getSettings().isWheelSneakToScroll() && player.isSneaking()) {
            return;
        }
        event.setCancelled(true);
        if (castWheel.wheelSize() > 1) {
            player.playSound(player.getLocation(), Fabled.getSettings().getWheelSoundsScroll(), (float)Fabled.getSettings().getWheelSoundsVolume(), 1.0f);
        }
        int previousSlot = event.getPreviousSlot();
        int newSlot = event.getNewSlot();
        int direction = (newSlot - previousSlot + 9) % 9;
        if (direction == 1) {
            castWheel.nextSkill();
        } else if (direction == 8) {
            castWheel.previousSkill();
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        castWheel.setCasting(false);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.dropPlayers.put(playerId, System.currentTimeMillis());
        Bukkit.getScheduler().runTaskLater((Plugin)Fabled.getPlugin(Fabled.class), () -> this.dropPlayers.remove(playerId), 3L);
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        if (!Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("DROP")) {
            return;
        }
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        if (!castWheel.isCasting()) {
            return;
        }
        event.setCancelled(true);
        castWheel.cast();
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        if (Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("DROP")) {
            return;
        }
        UUID playerId = event.getPlayer().getUniqueId();
        Long dropTime = this.dropPlayers.get(playerId);
        if (dropTime != null) {
            long now = System.currentTimeMillis();
            if (now - dropTime < 150L) {
                return;
            }
            this.dropPlayers.remove(playerId);
        }
        if ((event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) && !Fabled.getSettings().isAnimationLeftClick() && Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("LEFT_CLICK")) {
            PlayerData playerData = Fabled.getData((OfflinePlayer)player);
            PlayerCastWheel castWheel = playerData.getCastWheel();
            if (!castWheel.isCasting()) {
                return;
            }
            event.setCancelled(true);
            castWheel.cast();
        } else if ((event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) && Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("RIGHT_CLICK")) {
            PlayerData playerData = Fabled.getData((OfflinePlayer)player);
            PlayerCastWheel castWheel = playerData.getCastWheel();
            if (!castWheel.isCasting()) {
                return;
            }
            event.setCancelled(true);
            castWheel.cast();
        }
    }

    @EventHandler
    public void onEntityClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        if (!Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("RIGHT_CLICK")) {
            return;
        }
        if (!Fabled.getSettings().isInteractRightClick()) {
            return;
        }
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        if (!castWheel.isCasting()) {
            return;
        }
        event.setCancelled(true);
        castWheel.cast();
    }

    @EventHandler
    public void animation(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        if (!Fabled.getSettings().getWheelCastKey().equalsIgnoreCase("LEFT_CLICK")) {
            return;
        }
        if (!Fabled.getSettings().isAnimationLeftClick()) {
            return;
        }
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerCastWheel castWheel = playerData.getCastWheel();
        if (!castWheel.isCasting()) {
            return;
        }
        event.setCancelled(true);
        castWheel.cast();
    }

    private boolean isWorldEnabled(Player player) {
        return Fabled.getSettings().isWorldEnabled(player.getWorld());
    }

    public class CastWheelTask
    extends BukkitRunnable {
        private final PlayerData playerData;

        public CastWheelTask(PlayerData playerData) {
            this.playerData = playerData;
        }

        public void run() {
            Player player = this.playerData.getPlayer();
            if (!(CastWheelListener.this.enabled && player != null && player.isOnline() && CastWheelListener.this.isWorldEnabled(player) && this.playerData.getCastWheel().isCasting())) {
                this.cancel();
                return;
            }
            String message = this.playerData.getCastWheel().getMessage();
            if (PluginChecker.isPlaceholderAPIActive()) {
                message = PlaceholderAPIHook.format(message, player);
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        }

        public synchronized void cancel() throws IllegalStateException {
            super.cancel();
            Player player = this.playerData.getPlayer();
            if (player != null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
            }
        }
    }
}

