/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class DelayMechanic
extends MechanicComponent {
    private static final String SECONDS = "delay";
    private static final String CLEANUP = "cleanup";
    private static final String SINGLE_INSTANCE = "single-instance";
    final Map<UUID, List<Integer>> tasks = new HashMap<UUID, List<Integer>>();

    @Override
    public String getKey() {
        return SECONDS;
    }

    @Override
    public boolean execute(final LivingEntity caster, final int level, final List<LivingEntity> targets, final boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        boolean singleInstance = this.settings.getBool(SINGLE_INSTANCE, false);
        double seconds = this.parseValues(caster, SECONDS, level, 2.0);
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                DelayMechanic.this.executeChildren(caster, level, targets, force);
                DelayMechanic.this.tasks.get(caster.getUniqueId()).remove((Object)this.getTaskId());
            }
        }.runTaskLater((Plugin)Fabled.inst(), (long)(seconds * 20.0));
        this.tasks.compute(caster.getUniqueId(), (uuid, list) -> {
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            if (singleInstance) {
                list.forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0));
                list.clear();
            }
            list.add(task.getTaskId());
            return list;
        });
        return true;
    }

    @Override
    protected void doCleanUp(LivingEntity caster) {
        boolean shouldGetCleanedUp = this.settings.getBool(CLEANUP, true);
        if (!shouldGetCleanedUp) {
            return;
        }
        List<Integer> taskList = this.tasks.remove(caster.getUniqueId());
        if (taskList != null) {
            taskList.forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0));
        }
    }
}

