/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data;

import studio.magemonkey.fabled.api.particle.MatrixUtil;
import studio.magemonkey.fabled.data.Matrix3D;

public class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void rotate(double xRot, double yRot, double zRot) {
        Matrix3D rotMatrix = MatrixUtil.getRotationMatrix(xRot, yRot, zRot);
        Point3D newPoint = MatrixUtil.multiply(rotMatrix, this);
        this.x = newPoint.x;
        this.y = newPoint.y;
        this.z = newPoint.z;
    }

    public void rotateX(double xRot) {
        this.rotate(xRot, 0.0, 0.0);
    }

    public void rotateY(double yRot) {
        this.rotate(0.0, yRot, 0.0);
    }

    public void rotateZ(double zRot) {
        this.rotate(0.0, 0.0, zRot);
    }

    public String toString() {
        return "(" + String.format("%.2f", this.x) + ", " + String.format("%.2f", this.y) + ", " + String.format("%.2f", this.z) + ")";
    }
}

