/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.api.skills.SkillShot;
import studio.magemonkey.fabled.data.Click;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdCombo
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_SKILL = "not-skill";
    private static final String NOT_CASTABLE = "not-unlocked";
    private static final String NOT_CLICK = "not-click";
    private static final String NOT_COMBO = "not-combo";
    private static final String COMBO_SET = "skill-bound";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", silent, new CustomFilter[0]);
        } else if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
        } else if (args.length >= Fabled.getComboManager().getComboSize() + 1) {
            PlayerData player = Fabled.getData((OfflinePlayer)((Player)sender));
            Object name = args[0];
            int comboSize = Fabled.getComboManager().getComboSize();
            for (int i = 1; i < args.length - comboSize; ++i) {
                name = (String)name + " " + args[i];
            }
            PlayerSkill skill = player.getSkill((String)name);
            if (skill == null) {
                command.sendMessage(sender, NOT_SKILL, "&4You do not have that skill", silent, new CustomFilter[0]);
            } else if (!skill.getData().canCast()) {
                command.sendMessage(sender, NOT_CASTABLE, "&4That skill cannot be cast", silent, new CustomFilter[0]);
            } else {
                Click[] clicks = new Click[comboSize];
                for (int i = args.length - comboSize; i < args.length; ++i) {
                    Click click = Click.getByName(args[i]);
                    if (click == null) {
                        command.sendMessage(sender, NOT_CLICK, "&6{name} &4is not a valid click type. Use Left, Right, or Shift instead", silent, new CustomFilter[]{RPGFilter.NAME});
                        return;
                    }
                    clicks[i - args.length + comboSize] = click;
                }
                int id = Fabled.getComboManager().convertCombo(clicks);
                if (player.getComboData().setSkill(skill.getData(), id)) {
                    if (Fabled.getSettings().isSkillBarEnabled() && player.getSkillBar().isSetup()) {
                        player.getSkillBar().update((HumanEntity)player.getPlayer());
                    }
                    command.sendMessage(sender, COMBO_SET, "&2The combo for &6{skill} &2has been updated", silent, new CustomFilter[]{RPGFilter.SKILL.setReplacement(skill.getData().getName())});
                } else {
                    command.sendMessage(sender, NOT_COMBO, "&4That combo cannot be used", silent, new CustomFilter[0]);
                }
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)command, (CommandSender)sender);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!(commandSender instanceof Player)) {
            return null;
        }
        Player player = (Player)commandSender;
        List tabCompletions = ConfigurableCommand.getTabCompletions((Collection)Fabled.getData((OfflinePlayer)player).getSkills().stream().filter(playerSkill -> playerSkill.getData() instanceof SkillShot).map(playerSkill -> playerSkill.getData().getKey()).collect(Collectors.toList()), (String[])args);
        if (!tabCompletions.isEmpty() || args.length < 1) {
            return tabCompletions;
        }
        int comboSize = Fabled.getComboManager().getComboSize();
        int diff = Click.getByName(args[args.length - 1]) == null ? 1 : 0;
        for (int i = 1 + diff; i <= comboSize + diff; ++i) {
            if (args.length >= i && Click.getByName(args[args.length - i]) != null) continue;
            return ConfigurableCommand.getTabCompletions((Collection)Arrays.stream(Click.values()).map(click -> click.name().toLowerCase()).collect(Collectors.toList()), (String[])new String[]{args[args.length - 1]});
        }
        return null;
    }
}

