/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ThrowMechanic
extends MechanicComponent {
    private static final String SPEED = "speed";
    private static final String RELATIVE = "relative";
    private Vector up = new Vector(0, 1, 0);

    @Override
    public String getKey() {
        return "throw";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        double speed = this.parseValues(caster, SPEED, level, 0.0);
        String relative = this.settings.getString(RELATIVE, "target").toLowerCase();
        ArrayList<LivingEntity> thrown = new ArrayList<LivingEntity>();
        boolean worked = false;
        for (LivingEntity target : targets) {
            Entity toThrow = this.getTopOfStack((Entity)target);
            if (toThrow.equals((Object)target)) continue;
            Vector dir = relative.equals("caster") ? caster.getLocation().getDirection().normalize() : (relative.equals("thrown") ? toThrow.getLocation().getDirection().normalize() : target.getLocation().getDirection().normalize());
            dir.multiply(speed);
            toThrow.leaveVehicle();
            toThrow.setVelocity(dir);
            if (toThrow instanceof LivingEntity) {
                thrown.add((LivingEntity)toThrow);
            }
            worked = true;
        }
        if (!thrown.isEmpty()) {
            this.executeChildren(caster, level, thrown, force);
        }
        return worked;
    }

    private Entity getTopOfStack(Entity entity) {
        Entity top = entity;
        while (!top.getPassengers().isEmpty()) {
            top = (Entity)top.getPassengers().get(0);
        }
        return top;
    }
}

