/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import studio.magemonkey.fabled.api.event.SkillHealEvent;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class HealMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "heal";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean percent = this.settings.getString(TYPE, "health").toLowerCase().equals("percent");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        if (value < 0.0) {
            return false;
        }
        for (LivingEntity target : targets) {
            if (target.isDead()) continue;
            double amount = value;
            if (percent) {
                amount = target.getMaxHealth() * value / 100.0;
            }
            SkillHealEvent event = new SkillHealEvent(caster, target, amount);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            target.setHealth(Math.min(target.getHealth() + event.getAmount(), target.getMaxHealth()));
        }
        return targets.size() > 0;
    }
}

