/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class FlyMechanic
extends MechanicComponent {
    private static final String SECONDS = "seconds";
    private static final String FLY_SPEED = "flyspeed";
    private static final String ALLOW_FLIGHT = "allow-flight";
    private static final String FLYING = "flying";
    private final Map<Integer, Map<String, FlyTask>> tasks = new HashMap<Integer, Map<String, FlyTask>>();

    @Override
    public String getKey() {
        return "fly";
    }

    @Override
    protected void doCleanUp(LivingEntity user) {
        Map<String, FlyTask> casterTasks = this.tasks.remove(user.getEntityId());
        if (casterTasks != null) {
            casterTasks.values().forEach(FlyTask::stop);
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        int ticks = (int)(seconds * 20.0);
        float flyspeed = (float)this.parseValues(caster, FLY_SPEED, level, 0.1);
        boolean allowflight = this.settings.getString(ALLOW_FLIGHT, "false").equalsIgnoreCase("true");
        boolean flying = this.settings.getString(FLYING, "false").equalsIgnoreCase("true") && allowflight;
        Map casterTasks = this.tasks.computeIfAbsent(caster.getEntityId(), HashMap::new);
        for (LivingEntity target : targets) {
            Player player;
            if (!(target instanceof Player) || (player = (Player)target).getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) continue;
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)target));
            if (flyspeed > 1.0f) {
                flyspeed = 1.0f;
            } else if (flyspeed < -1.0f) {
                flyspeed = -1.0f;
            }
            player.setAllowFlight(allowflight);
            player.setFlying(flying);
            player.setFlySpeed(flyspeed);
            if (casterTasks.containsKey(data.getPlayerName())) {
                FlyTask oldTask = (FlyTask)((Object)casterTasks.remove(data.getPlayerName()));
                oldTask.cancel();
            }
            if (!flying) continue;
            FlyTask task = new FlyTask(caster.getEntityId(), data);
            casterTasks.put(data.getPlayerName(), task);
            if (ticks < 0) continue;
            Fabled.schedule(task, ticks);
        }
        return !targets.isEmpty();
    }

    private class FlyTask
    extends BukkitRunnable {
        private final PlayerData data;
        private final int id;
        private boolean running = false;
        private boolean stopped = false;

        FlyTask(int id, PlayerData data) {
            this.id = id;
            this.data = data;
        }

        public void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.run();
                if (this.running) {
                    this.cancel();
                }
            }
        }

        @NotNull
        public BukkitTask runTaskLater(@NotNull Plugin plugin, long delay) {
            this.running = true;
            return super.runTaskLater(plugin, delay);
        }

        public void run() {
            Player player = this.data.getPlayer();
            if (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            player.setFlySpeed(0.1f);
            if (FlyMechanic.this.tasks.containsKey(this.id)) {
                FlyMechanic.this.tasks.get(this.id).remove(this.data.getPlayerName());
            }
            this.running = false;
        }
    }
}

