/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class MoonCondition
extends ConditionComponent {
    private static final String PHASES = "phases";
    private static final String BLACKLIST = "blacklist";
    private Set<String> phases;
    private boolean blacklist;
    private final String[] phaseNames = new String[]{"FULL MOON", "WANING GIBBOUS", "LAST QUARTER", "WANING CRESCENT", "NEW MOON", "WAXING CRESCENT", "FIRST QUARTER", "WAXING GIBBOUS"};

    @Override
    public String getKey() {
        return "moon";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.phases = this.settings.getStringList(PHASES).stream().map(s -> s.toUpperCase(Locale.US)).collect(Collectors.toSet());
        this.blacklist = this.settings.getString(BLACKLIST).equalsIgnoreCase("True");
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        World world = target.getWorld();
        int day = (int)(world.getFullTime() / 24000L) % 8;
        String currentPhase = this.phaseNames[day];
        return this.phases.contains(currentPhase) != this.blacklist;
    }
}

