/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import lombok.Generated;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.data.sql.tables.FabledPlayersSQL;

public class SQLManager {
    private static volatile Connection connection;
    private static FabledPlayersSQL fabledPlayersSQL;
    private static String host;
    private static int port;
    private static String database;
    private static String user;
    private static String password;

    public static void reconnect() {
        connection = SQLManager.getMySQLConnection(host, port, database, user, password);
        if (connection == null) {
            Fabled.inst().getLogger().severe("Failed to connect to database.");
        }
    }

    public static void reload() {
        host = Fabled.getSettings().getSqlHost();
        port = Integer.parseInt(Fabled.getSettings().getSqlPort());
        database = Fabled.getSettings().getSqlDatabase();
        user = Fabled.getSettings().getSqlUser();
        password = Fabled.getSettings().getSqlPass();
        Fabled.inst().getLogger().info("Initializing SQLManager with type: MySQL");
        SQLManager.reconnect();
        if (connection != null) {
            Fabled.inst().getLogger().info("Connection established to database: " + database);
        }
        fabledPlayersSQL = new FabledPlayersSQL();
    }

    private static Connection getSQLiteConnection() {
        File databaseFile = new File(Fabled.inst().getDataFolder(), "database.db");
        databaseFile.getParentFile().mkdirs();
        try {
            String url = "jdbc:sqlite:" + databaseFile.getAbsolutePath();
            Connection conn = DriverManager.getConnection(url);
            Fabled.inst().getLogger().info("SQLite connection created at: " + databaseFile.getAbsolutePath());
            return conn;
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().severe("Error creating SQLite connection: " + e.getMessage());
            return null;
        }
    }

    private static Connection getMySQLConnection(String host, int port, String database, String user, String password) {
        try {
            String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
            Connection conn = DriverManager.getConnection(url, user, password);
            return conn;
        }
        catch (SQLException e) {
            Fabled.inst().getLogger().severe("Error creating MySQL connection: " + e.getMessage());
            return null;
        }
    }

    public static Connection connection() throws SQLException {
        if (connection == null || connection.isClosed()) {
            SQLManager.reconnect();
        }
        if (connection != null) {
            return connection;
        }
        Fabled.inst().getLogger().severe("Connection is still null after initialization attempt.");
        return null;
    }

    public static void runMigrations() {
        if (fabledPlayersSQL != null) {
            fabledPlayersSQL.migrateTable();
        }
    }

    public static FabledPlayersSQL players() {
        return fabledPlayersSQL;
    }

    @Generated
    public static Connection getConnection() {
        return connection;
    }
}

