/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.block.BlockPlaceEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class BlockPlaceTrigger
implements Trigger<BlockPlaceEvent> {
    @Override
    public String getKey() {
        return "BLOCK_PLACE";
    }

    @Override
    public Class<BlockPlaceEvent> getEvent() {
        return BlockPlaceEvent.class;
    }

    @Override
    public boolean shouldTrigger(BlockPlaceEvent event, int level, Settings settings) {
        List<String> types = settings.getStringList("material");
        return types.isEmpty() || types.contains("Any") || types.stream().anyMatch(mat -> event.getBlock().getType().name().equalsIgnoreCase(mat.replace(' ', '_')));
    }

    @Override
    public void setValues(BlockPlaceEvent event, CastData data) {
        data.put("api-block-type", event.getBlock().getType().name());
        data.put("api-block-loc", event.getBlock().getLocation());
    }

    @Override
    public LivingEntity getCaster(BlockPlaceEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(BlockPlaceEvent event, Settings settings) {
        return event.getPlayer();
    }
}

