/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import java.util.Locale;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ImmunityMechanic
extends MechanicComponent {
    public static final String META_KEY = "sapi_immunity";
    private static final String TYPE = "type";
    private static final String SECONDS = "seconds";
    private static final String MULTIPLIER = "multiplier";

    @Override
    public String getKey() {
        return "immunity";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(TYPE)) {
            return false;
        }
        String key = this.settings.getString(TYPE);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        double multiplier = this.parseValues(caster, MULTIPLIER, level, 0.0);
        int ticks = (int)(seconds * 20.0);
        for (LivingEntity target : targets) {
            FlagManager.addFlag(target, "immune:" + key.toUpperCase(Locale.US).replace(" ", "_"), ticks);
            Fabled.setMeta((Metadatable)target, META_KEY, multiplier);
        }
        return targets.size() > 0;
    }
}

