/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle;

import java.util.function.Consumer;
import studio.magemonkey.fabled.api.particle.IParticleEffect;
import studio.magemonkey.fabled.api.particle.target.EffectTarget;

public class EffectInstance {
    private final IParticleEffect effect;
    private final EffectTarget target;
    private final int level;
    private int life;
    private int tick;
    private int frame;

    public EffectInstance(IParticleEffect effect, EffectTarget target, int level) {
        this.effect = effect;
        this.target = target;
        this.level = level;
        this.life = 0;
        this.tick = -1;
        this.frame = 0;
    }

    public boolean isValid() {
        return this.target.isValid() && this.life > 0;
    }

    public EffectInstance ifValid(Consumer<EffectInstance> consumer) {
        if (this.isValid()) {
            consumer.accept(this);
        }
        return this;
    }

    public EffectInstance ifValidOrElse(Consumer<EffectInstance> consumer, Consumer<EffectInstance> orElse) {
        if (this.isValid()) {
            consumer.accept(this);
        } else {
            orElse.accept(this);
        }
        return this;
    }

    public void extend(int duration) {
        this.life = Math.max(this.life, duration);
    }

    public void tick() {
        ++this.tick;
        if (this.tick % this.effect.getInterval() == 0) {
            this.effect.play(this.target.getLocation(), this.frame, this.level);
            ++this.frame;
            this.tick = 0;
        }
        --this.life;
    }
}

