/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.classes;

import java.util.Locale;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.classes.TreeType;
import studio.magemonkey.fabled.tree.basic.BasicHorizontalTree;
import studio.magemonkey.fabled.tree.basic.BasicVerticalTree;
import studio.magemonkey.fabled.tree.basic.CustomTree;
import studio.magemonkey.fabled.tree.basic.FloodTree;
import studio.magemonkey.fabled.tree.basic.InventoryTree;
import studio.magemonkey.fabled.tree.basic.LevelHorizontalTree;
import studio.magemonkey.fabled.tree.basic.LevelVerticalTree;
import studio.magemonkey.fabled.tree.basic.RequirementTree;

public enum DefaultTreeType implements TreeType
{
    BASIC_HORIZONTAL,
    BASIC_VERTICAL,
    LEVEL_HORIZONTAL,
    LEVEL_VERTICAL,
    FLOOD,
    REQUIREMENT,
    CUSTOM;


    @Override
    public InventoryTree getTree(Fabled api, FabledClass parent) {
        switch (this.ordinal()) {
            case 0: {
                return new BasicHorizontalTree(api, parent);
            }
            case 1: {
                return new BasicVerticalTree(api, parent);
            }
            case 2: {
                return new LevelHorizontalTree(api, parent);
            }
            case 3: {
                return new LevelVerticalTree(api, parent);
            }
            case 4: {
                return new FloodTree(api, parent);
            }
            case 5: {
                return new RequirementTree(api, parent);
            }
            case 6: {
                return new CustomTree(api, parent);
            }
        }
        return null;
    }

    public static DefaultTreeType getByName(String name) {
        try {
            return Enum.valueOf(DefaultTreeType.class, name.toUpperCase(Locale.US).replace(' ', '_'));
        }
        catch (Exception ex) {
            return REQUIREMENT;
        }
    }
}

