/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class EnvironmentalTrigger
implements Trigger<EntityDamageEvent> {
    @Override
    public String getKey() {
        return "ENVIRONMENT_DAMAGE";
    }

    @Override
    public Class<EntityDamageEvent> getEvent() {
        return EntityDamageEvent.class;
    }

    @Override
    public boolean shouldTrigger(EntityDamageEvent event, int level, Settings settings) {
        if (event instanceof EntityDamageByEntityEvent && DefaultCombatProtection.isFakeDamageEvent((EntityDamageByEntityEvent)event)) {
            return false;
        }
        List types = settings.getStringList("type").stream().map(str -> str.replace(' ', '_').toUpperCase(Locale.US)).collect(Collectors.toList());
        boolean isAny = types.contains("ANY");
        return isAny || types.contains(event.getCause().name());
    }

    @Override
    public void setValues(EntityDamageEvent event, CastData data) {
        data.put("api-taken", event.getDamage());
    }

    @Override
    public LivingEntity getCaster(EntityDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            return (LivingEntity)event.getEntity();
        }
        return null;
    }

    @Override
    public LivingEntity getTarget(EntityDamageEvent event, Settings settings) {
        return this.getCaster(event);
    }

    @Override
    public void postProcess(EntityDamageEvent event, DynamicSkill skill) {
        double damage = skill.applyImmediateBuff(event.getDamage());
        event.setDamage(damage);
    }
}

