/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;

public class CmdSwitch
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_CLASS = "not-class";
    private static final String CHANGED = "account-changed";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", silent, new CustomFilter[0]);
        } else if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
        } else if (args.length == 0) {
            command.displayHelp(sender);
        } else {
            PlayerAccounts player = Fabled.getPlayerAccounts((OfflinePlayer)((Player)sender));
            FabledClass fabledClass = this.getRoot(Fabled.getClass(args[0]));
            if (fabledClass != null) {
                boolean done = false;
                for (Map.Entry<Integer, PlayerData> entry : player.getAllData().entrySet()) {
                    PlayerClass accountClass = entry.getValue().getMainClass();
                    if (accountClass == null || this.getRoot(accountClass.getData()) != fabledClass) continue;
                    player.setAccount(entry.getKey());
                    done = true;
                    break;
                }
                if (!done) {
                    int i = 1;
                    if (player.getActiveData().getMainClass() != null) {
                        while (player.getData(i) != null) {
                            ++i;
                        }
                    }
                    player.setAccount(i);
                    player.getActiveData().profess(fabledClass);
                }
                command.sendMessage(sender, CHANGED, String.valueOf(ChatColor.DARK_GREEN) + "You have changed classes", silent, new CustomFilter[0]);
                return;
            }
            command.sendMessage(sender, NOT_CLASS, String.valueOf(ChatColor.RED) + "That is not a valid class", silent, new CustomFilter[0]);
        }
    }

    private FabledClass getRoot(FabledClass fabledClass) {
        if (fabledClass == null) {
            return null;
        }
        while (fabledClass.getParent() != null) {
            fabledClass = fabledClass.getParent();
        }
        return fabledClass;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            return ConfigurableCommand.getTabCompletions((Collection)Fabled.getClasses().values().stream().map(FabledClass::getName).collect(Collectors.toList()), (String[])args);
        }
        return null;
    }
}

