/**
 * Fabled
 * studio.magemonkey.fabled.data.Permissions
 * <p>
 * The MIT License (MIT)
 * <p>
 * Copyright (c) 2024 MageMonkeyStudio
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software") to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package studio.magemonkey.fabled.data;

/**
 * Permission nodes used by the plugin
 */
public class Permissions {
    private static final String ROOT = "fabled.";

    public static final String BASIC        = ROOT + "basic";
    public static final String BACKUP       = ROOT + "backup";
    public static final String EXP          = ROOT + "exp";
    public static final String LVL          = ROOT + "level";
    public static final String MANA         = ROOT + "mana";
    public static final String POINTS       = ROOT + "points";
    public static final String SKILL        = ROOT + "skill";
    public static final String CLASS        = ROOT + "class";
    public static final String RELOAD       = ROOT + "reload";
    public static final String FORCE        = ROOT + "force";
    public static final String LORE         = ROOT + "lore";
    public static final String ATTRIB       = ROOT + "attrib";
    public static final String GUI          = ROOT + "gui";
    public static final String WORLD        = ROOT + "world";
    public static final String RESET        = ROOT + "reset";
    public static final String REFUND       = ROOT + "refund";
    public static final String MAX_ACCOUNTS = ROOT + "max_accounts";
}
