/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree.basic;

import java.util.List;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUIType;
import studio.magemonkey.fabled.tree.basic.InventoryTree;

public class CustomTree
extends InventoryTree {
    public CustomTree(Fabled api, FabledClass tree) {
        super(api, tree);
    }

    @Override
    protected void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        this.height = 3;
        DataSection section = Fabled.getConfig("gui").getConfig().getSection(GUIType.SKILL_TREE.getPrefix() + this.tree.getName());
        if (section == null) {
            return;
        }
        this.height = Math.max(1, Math.min(section.getInt("rows", 3), 6));
        DataSection slotsSection = section.getSection("slots");
        if (slotsSection == null) {
            return;
        }
        for (String key : slotsSection.keys()) {
            int page = Integer.parseInt(key);
            DataSection pageSection = slotsSection.getSection(key);
            for (String skillName : pageSection.keys()) {
                Skill skill = Fabled.getSkill(skillName);
                if (skill == null) continue;
                this.skillSlots.put(pageSection.getInt(skillName) + (page - 1) * this.height * 9, skill);
            }
        }
    }
}

