/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.shield;

import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.codex.util.MsgUT;
import studio.magemonkey.fabled.shield.FabledShieldBreakEvent;
import studio.magemonkey.fabled.shield.FabledShieldDamageEvent;
import studio.magemonkey.fabled.shield.ShieldDisplay;

public class ShieldEffect {
    private final String name;
    private final String classifier;
    private final double amount;
    private double percent = 1.0;
    private ShieldDisplay displayLocation = ShieldDisplay.ACTION_BAR;
    private double taken;
    private BossBar bossBar;
    private BarColor barColor = BarColor.GREEN;
    private BarStyle barStyle = BarStyle.SOLID;
    private Keyed hitSound;
    private Keyed breakSound;
    private BukkitTask task;

    public ShieldEffect(String name, String classifier, double amount, double percent) {
        this(name, classifier, amount);
        this.percent = percent;
    }

    public void destroy() {
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar = null;
        }
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void breakShield(LivingEntity entity) {
        if (this.breakSound != null && entity instanceof Player) {
            ((Player)entity).playSound(entity.getLocation(), this.breakSound.getKey().getKey(), 1.0f, 1.0f);
        }
        FabledShieldBreakEvent event = new FabledShieldBreakEvent(entity, this);
        entity.getServer().getPluginManager().callEvent((Event)event);
        this.destroy();
    }

    public double damage(LivingEntity entity, double amount) {
        double modified = amount * this.percent;
        modified = Math.min(modified, this.getRemaining());
        this.taken += modified;
        if (this.isExhausted()) {
            this.breakShield(entity);
        } else if (this.hitSound != null && entity instanceof Player) {
            ((Player)entity).playSound(entity.getLocation(), this.hitSound.getKey().getKey(), 1.0f, 1.0f);
        }
        FabledShieldDamageEvent event = new FabledShieldDamageEvent(entity, this, modified);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return amount - modified;
    }

    public double damageAndDisplay(double amount, LivingEntity entity) {
        double remaining = this.damage(entity, amount);
        if (entity instanceof Player) {
            this.display((Player)entity);
        }
        return remaining;
    }

    public double getRemaining() {
        return this.amount - this.taken;
    }

    public boolean isExhausted() {
        return this.taken >= this.amount;
    }

    public void display(Player player) {
        switch (this.displayLocation) {
            case ACTION_BAR: {
                this.displayActionBar(player);
                break;
            }
            case BOSS_BAR: {
                if (this.isExhausted()) {
                    return;
                }
                this.displayBossBar(player);
                break;
            }
            case TITLE: {
                this.displayTitle(player);
                break;
            }
            default: {
                this.displayChat(player);
            }
        }
    }

    private void displayChat(Player player) {
        player.sendMessage(this.name + ": " + this.getFormattedShieldString());
    }

    private void displayActionBar(Player player) {
        MsgUT.sendActionBar((Player)player, (String)(this.name + ": " + this.getFormattedShieldString()));
    }

    private void displayTitle(Player player) {
        MsgUT.sendTitles((Player)player, (String)this.getFormattedShieldString(), (String)this.name, (int)0, (int)20, (int)0);
    }

    private void displayBossBar(Player player) {
        if (this.bossBar == null) {
            this.bossBar = player.getServer().createBossBar(this.name, this.barColor, this.barStyle, new BarFlag[0]);
        }
        this.bossBar.setProgress(this.getRemaining() / this.amount);
        if (!this.bossBar.getPlayers().contains(player)) {
            this.bossBar.addPlayer(player);
        }
    }

    private String getFormattedShieldString() {
        double percentUsed = this.taken / this.amount;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            if (percentUsed * 10.0 - (double)i >= 1.0) {
                builder.append(ChatColor.RED);
            } else if (percentUsed * 10.0 - (double)i >= 0.5) {
                builder.append(ChatColor.YELLOW);
            } else {
                builder.append(ChatColor.GREEN);
            }
            builder.append("\u2588");
        }
        return builder.toString();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getClassifier() {
        return this.classifier;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public double getPercent() {
        return this.percent;
    }

    @Generated
    public ShieldDisplay getDisplayLocation() {
        return this.displayLocation;
    }

    @Generated
    public double getTaken() {
        return this.taken;
    }

    @Generated
    public BarColor getBarColor() {
        return this.barColor;
    }

    @Generated
    public BarStyle getBarStyle() {
        return this.barStyle;
    }

    @Generated
    public Keyed getHitSound() {
        return this.hitSound;
    }

    @Generated
    public Keyed getBreakSound() {
        return this.breakSound;
    }

    @Generated
    public BukkitTask getTask() {
        return this.task;
    }

    @Generated
    public void setPercent(double percent) {
        this.percent = percent;
    }

    @Generated
    public void setDisplayLocation(ShieldDisplay displayLocation) {
        this.displayLocation = displayLocation;
    }

    @Generated
    public void setTaken(double taken) {
        this.taken = taken;
    }

    @Generated
    public void setBarColor(BarColor barColor) {
        this.barColor = barColor;
    }

    @Generated
    public void setBarStyle(BarStyle barStyle) {
        this.barStyle = barStyle;
    }

    @Generated
    public void setHitSound(Keyed hitSound) {
        this.hitSound = hitSound;
    }

    @Generated
    public void setBreakSound(Keyed breakSound) {
        this.breakSound = breakSound;
    }

    @Generated
    public void setTask(BukkitTask task) {
        this.task = task;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShieldEffect)) {
            return false;
        }
        ShieldEffect other = (ShieldEffect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getPercent(), other.getPercent()) != 0) {
            return false;
        }
        if (Double.compare(this.getTaken(), other.getTaken()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        ShieldDisplay this$displayLocation = this.getDisplayLocation();
        ShieldDisplay other$displayLocation = other.getDisplayLocation();
        if (this$displayLocation == null ? other$displayLocation != null : !((Object)((Object)this$displayLocation)).equals((Object)other$displayLocation)) {
            return false;
        }
        BossBar this$bossBar = this.getBossBar();
        BossBar other$bossBar = other.getBossBar();
        if (this$bossBar == null ? other$bossBar != null : !this$bossBar.equals(other$bossBar)) {
            return false;
        }
        BarColor this$barColor = this.getBarColor();
        BarColor other$barColor = other.getBarColor();
        if (this$barColor == null ? other$barColor != null : !this$barColor.equals(other$barColor)) {
            return false;
        }
        BarStyle this$barStyle = this.getBarStyle();
        BarStyle other$barStyle = other.getBarStyle();
        if (this$barStyle == null ? other$barStyle != null : !this$barStyle.equals(other$barStyle)) {
            return false;
        }
        Keyed this$hitSound = this.getHitSound();
        Keyed other$hitSound = other.getHitSound();
        if (this$hitSound == null ? other$hitSound != null : !this$hitSound.equals(other$hitSound)) {
            return false;
        }
        Keyed this$breakSound = this.getBreakSound();
        Keyed other$breakSound = other.getBreakSound();
        if (this$breakSound == null ? other$breakSound != null : !this$breakSound.equals(other$breakSound)) {
            return false;
        }
        BukkitTask this$task = this.getTask();
        BukkitTask other$task = other.getTask();
        return !(this$task == null ? other$task != null : !this$task.equals(other$task));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShieldEffect;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $percent = Double.doubleToLongBits(this.getPercent());
        result = result * 59 + (int)($percent >>> 32 ^ $percent);
        long $taken = Double.doubleToLongBits(this.getTaken());
        result = result * 59 + (int)($taken >>> 32 ^ $taken);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        ShieldDisplay $displayLocation = this.getDisplayLocation();
        result = result * 59 + ($displayLocation == null ? 43 : ((Object)((Object)$displayLocation)).hashCode());
        BossBar $bossBar = this.getBossBar();
        result = result * 59 + ($bossBar == null ? 43 : $bossBar.hashCode());
        BarColor $barColor = this.getBarColor();
        result = result * 59 + ($barColor == null ? 43 : $barColor.hashCode());
        BarStyle $barStyle = this.getBarStyle();
        result = result * 59 + ($barStyle == null ? 43 : $barStyle.hashCode());
        Keyed $hitSound = this.getHitSound();
        result = result * 59 + ($hitSound == null ? 43 : $hitSound.hashCode());
        Keyed $breakSound = this.getBreakSound();
        result = result * 59 + ($breakSound == null ? 43 : $breakSound.hashCode());
        BukkitTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShieldEffect(name=" + this.getName() + ", classifier=" + this.getClassifier() + ", amount=" + this.getAmount() + ", percent=" + this.getPercent() + ", displayLocation=" + String.valueOf((Object)this.getDisplayLocation()) + ", taken=" + this.getTaken() + ", bossBar=" + String.valueOf(this.getBossBar()) + ", barColor=" + String.valueOf(this.getBarColor()) + ", barStyle=" + String.valueOf(this.getBarStyle()) + ", hitSound=" + String.valueOf(this.getHitSound()) + ", breakSound=" + String.valueOf(this.getBreakSound()) + ", task=" + String.valueOf(this.getTask()) + ")";
    }

    @Generated
    public ShieldEffect(String name, String classifier, double amount) {
        this.name = name;
        this.classifier = classifier;
        this.amount = amount;
    }

    @Generated
    private BossBar getBossBar() {
        return this.bossBar;
    }

    @Generated
    private void setBossBar(BossBar bossBar) {
        this.bossBar = bossBar;
    }
}

