/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.mechanic.PotionProjectileMechanic;
import studio.magemonkey.fabled.listener.FabledListener;

public class LingeringPotionListener
extends FabledListener {
    @EventHandler
    public void onLingerSplash(LingeringPotionSplashEvent event) {
        PotionProjectileMechanic mechanic = (PotionProjectileMechanic)Fabled.getMeta((Metadatable)event.getEntity(), "potionProjectile");
        if (mechanic != null) {
            MetadataValue levelMetadata = (MetadataValue)event.getEntity().getMetadata("skill_level").get(0);
            int level = levelMetadata.asInt();
            Settings settings = mechanic.getSettings();
            AreaEffectCloud aec = event.getAreaEffectCloud();
            aec.setDuration((int)settings.getAttr("duration", level, 30.0) * 20);
            aec.setWaitTime((int)settings.getAttr("wait-time", level, 0.5) * 20);
            aec.setReapplicationDelay((int)settings.getAttr("reapplication-delay", level, 1.0) * 20);
            aec.setDurationOnUse((int)settings.getAttr("duration-on-use", level, 0.0) * 20);
            aec.setRadius((float)settings.getAttr("cloud-radius", level, 3.0));
            aec.setRadiusOnUse((float)settings.getAttr("radius-on-use", level, -0.5));
            aec.setRadiusPerTick((float)settings.getAttr("radius-per-tick", level, -0.01) / 20.0f);
            Particle particle = ParticleHelper.getFromKey(settings.getString("cloud-particle", "Spell mob"));
            aec.setParticle(particle, ParticleHelper.makeObject(particle, Material.valueOf((String)settings.getString("cloud-material", "Dirt").toUpperCase(Locale.US).replace(" ", "_")), settings.getInt("cloud-type", 0), settings.getInt("cloud-durability", 0), Color.fromRGB((int)Integer.parseInt(settings.getString("cloud-dust-color", "#FF0000").substring(1), 16)), Color.fromRGB((int)Integer.parseInt(settings.getString("cloud-final-dust-color", "#FF0000").substring(1), 16)), (float)settings.getDouble("cloud-dust-size", 1.0)));
            Fabled.setMeta((Metadatable)aec, "potionProjectile", mechanic);
            aec.setMetadata("skill_level", levelMetadata);
            aec.setMetadata("caster", (MetadataValue)event.getEntity().getMetadata("caster").get(0));
        }
    }

    @EventHandler
    public void onLinger(AreaEffectCloudApplyEvent event) {
        PotionProjectileMechanic mechanic = (PotionProjectileMechanic)Fabled.getMeta((Metadatable)event.getEntity(), "potionProjectile");
        if (mechanic != null) {
            event.setCancelled(true);
            mechanic.callback((Entity)event.getEntity(), event.getAffectedEntities());
        }
    }
}

