/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.ProjectileTickEvent;
import studio.magemonkey.fabled.api.particle.target.EntityTarget;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class ProjectileTickTrigger
implements Trigger<ProjectileTickEvent> {
    private Map<UUID, Integer> timer = new HashMap<UUID, Integer>();

    @Override
    public String getKey() {
        return "PROJECTILE_TICK";
    }

    @Override
    public Class<ProjectileTickEvent> getEvent() {
        return ProjectileTickEvent.class;
    }

    @Override
    public boolean shouldTrigger(ProjectileTickEvent event, int level, Settings settings) {
        boolean isTimerTick;
        boolean correctProjectile;
        Entity proj = event.getEntity();
        List<String> projectiles = settings.getStringList("projectile");
        boolean bl = correctProjectile = projectiles.isEmpty() || projectiles.contains("Any") || projectiles.stream().anyMatch(projectile -> proj.getType().name().equalsIgnoreCase((String)projectile));
        if (!correctProjectile) {
            return false;
        }
        int interval = settings.getInt("interval", 1);
        int delay = settings.getInt("delay", 0);
        UUID projectileUUID = event.getProjectile().getUniqueId();
        if (!this.timer.containsKey(projectileUUID)) {
            this.timer.put(projectileUUID, 0);
        }
        int timerValue = this.timer.get(event.getProjectile().getUniqueId());
        boolean bl2 = isTimerTick = event.getTick() - timerValue * interval - delay >= 0;
        if (isTimerTick) {
            this.timer.put(projectileUUID, timerValue + 1);
        }
        return isTimerTick;
    }

    @Override
    public void setValues(ProjectileTickEvent event, CastData data) {
    }

    @Override
    public LivingEntity getCaster(ProjectileTickEvent event) {
        return (LivingEntity)event.getEntity();
    }

    @Override
    public LivingEntity getTarget(ProjectileTickEvent event, Settings settings) {
        boolean targetCaster = settings.getBool("target", false);
        return targetCaster ? (LivingEntity)event.getEntity() : new TempEntity(new EntityTarget((Entity)event.getProjectile()));
    }

    public void removeProjectile(UUID uuid) {
        this.timer.remove(uuid);
    }
}

