/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.FlagApplyEvent;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class FlagTrigger
implements Trigger<FlagApplyEvent> {
    @Override
    public String getKey() {
        return "FLAG";
    }

    @Override
    public Class<FlagApplyEvent> getEvent() {
        return FlagApplyEvent.class;
    }

    @Override
    public boolean shouldTrigger(FlagApplyEvent event, int level, Settings settings) {
        List<String> flags = settings.getStringList("flags");
        boolean inverted = settings.getBool("inverted", false);
        double minDuration = settings.getDouble("min-duration", 0.0);
        int ticks = (int)minDuration * 20;
        if (event.getTicks() < ticks) {
            return false;
        }
        return (flags.isEmpty() || flags.contains("Any") || flags.contains(event.getFlag())) != inverted;
    }

    @Override
    public void setValues(FlagApplyEvent event, CastData data) {
        data.put("api-" + event.getFlag() + "-duration", event.getTicks());
    }

    @Override
    public LivingEntity getCaster(FlagApplyEvent event) {
        return event.getEntity();
    }

    @Override
    public LivingEntity getTarget(FlagApplyEvent event, Settings settings) {
        return event.getEntity();
    }
}

