/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.TriggerHandler;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;
import studio.magemonkey.fabled.dynamic.trigger.TriggerComponent;

public class TriggerMechanic
extends MechanicComponent {
    private static final String TRIGGER = "trigger";
    private static final String DURATION = "duration";
    private static final String STACKABLE = "stackable";
    private static final String ONCE = "once";
    private final Map<Integer, List<Context>> CASTER_MAP = new HashMap<Integer, List<Context>>();
    private TriggerHandler triggerHandler;
    private boolean once;
    private boolean stackable;

    @Override
    public void load(DynamicSkill skill, DataSection dataSection) {
        super.load(skill, dataSection);
        String name = this.settings.getString(TRIGGER, "DEATH");
        Trigger<?> trigger = ComponentRegistry.getTrigger(name);
        if (trigger == null) {
            throw new IllegalArgumentException("Skill is using invalid trigger for mechanic: " + name);
        }
        Receiver receiver = new Receiver();
        this.triggerHandler = new TriggerHandler(skill, "fake", trigger, receiver);
        this.triggerHandler.register(Fabled.inst());
        this.once = this.settings.getBool(ONCE, true);
        this.stackable = this.settings.getBool(STACKABLE, true);
    }

    @Override
    public String getKey() {
        return TRIGGER;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        int ticks = (int)(20.0 * this.parseValues(caster, DURATION, level, 5.0));
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!this.stackable && this.CASTER_MAP.containsKey(target.getEntityId())) {
                return false;
            }
            if (!this.CASTER_MAP.containsKey(target.getEntityId())) {
                this.CASTER_MAP.put(target.getEntityId(), new ArrayList());
            }
            this.triggerHandler.init(target, level);
            Context context = new Context(caster, level);
            this.CASTER_MAP.get(target.getEntityId()).add(context);
            Fabled.schedule(new StopTask(target, context), ticks);
            worked = true;
        }
        return worked;
    }

    private void remove(LivingEntity target, Context context) {
        List<Context> contexts = this.CASTER_MAP.get(target.getEntityId());
        if (contexts == null) {
            return;
        }
        contexts.remove(context);
        if (contexts.isEmpty()) {
            this.CASTER_MAP.remove(target.getEntityId());
            this.triggerHandler.cleanup(target);
        }
    }

    private class Receiver
    extends TriggerComponent {
        private Receiver() {
            DataSection data = new DataSection();
            TriggerMechanic.this.settings.save(data);
            this.settings.load(data);
        }

        @Override
        public boolean execute(LivingEntity target, int level, List<LivingEntity> targets, boolean force) {
            if (!TriggerMechanic.this.CASTER_MAP.containsKey(target.getEntityId())) {
                return false;
            }
            List<Context> contexts = TriggerMechanic.this.once ? TriggerMechanic.this.CASTER_MAP.remove(target.getEntityId()) : TriggerMechanic.this.CASTER_MAP.get(target.getEntityId());
            ArrayList<LivingEntity> targetList = new ArrayList<LivingEntity>();
            targetList.add(target);
            for (Context context : contexts) {
                DynamicSkill.getCastData(context.caster).put("listen-target", targetList);
                TriggerMechanic.this.executeChildren(context.caster, context.level, targets, force);
            }
            return true;
        }
    }

    private static class Context {
        public final LivingEntity caster;
        public final int level;

        public Context(LivingEntity caster, int level) {
            this.caster = caster;
            this.level = level;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            return context.caster == this.caster && context.level == this.level;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.caster, this.level});
        }
    }

    private class StopTask
    implements Runnable {
        private final LivingEntity target;
        private final Context context;

        public StopTask(LivingEntity target, Context context) {
            this.target = target;
            this.context = context;
        }

        @Override
        public void run() {
            TriggerMechanic.this.remove(this.target, this.context);
        }
    }
}

