/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class EntityTypeCondition
extends ConditionComponent {
    private static final String TYPE = "types";
    private static final String BLACKLIST = "blacklist";
    private Set<String> types;

    @Override
    public String getKey() {
        return "entity type";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.types = this.settings.getStringList(TYPE).stream().map(s -> s.toUpperCase(Locale.US).replace(' ', '_')).collect(Collectors.toSet());
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        boolean result = target instanceof TempEntity ? this.types.contains("LOCATION") : this.types.contains(target.getType().name());
        return this.settings.getBool(BLACKLIST, false) != result;
    }
}

