/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;

public class CmdForceSkill
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_SKILL = "not-skill";
    private static final String NOT_FUNCTION = "not-function";
    private static final String UPGRADED = "skill-upped";
    private static final String DOWNGRADED = "skill-downed";
    private static final String RESET = "skill-reset";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (args.length < 3) {
            command.displayHelp(sender);
        } else {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
            if (player == null) {
                command.sendMessage(sender, NOT_PLAYER, "&4That is not a valid player name", silent, new CustomFilter[0]);
                return;
            }
            PlayerData playerData = Fabled.getData(player);
            StringBuilder skillName = new StringBuilder(args[2]);
            for (int i = 3; i < args.length; ++i) {
                skillName.append(" " + args[i]);
            }
            PlayerSkill skill = playerData.getSkill(skillName.toString());
            if (skill == null) {
                command.sendMessage(sender, NOT_SKILL, "&4The player does not have access to that skill", silent, new CustomFilter[0]);
                return;
            }
            if (args[1].equals("up")) {
                playerData.forceUpSkill(skill);
                command.sendMessage(sender, UPGRADED, "&6" + skill.getData().getName() + "&2 was upgraded for &6" + player.getName(), silent, new CustomFilter[0]);
            } else if (args[1].equals("down")) {
                playerData.forceDownSkill(skill);
                command.sendMessage(sender, DOWNGRADED, "&6" + skill.getData().getName() + "&2 was downgraded for &6" + player.getName(), silent, new CustomFilter[0]);
            } else if (args[1].equals("reset")) {
                playerData.refundSkill(skill);
                command.sendMessage(sender, RESET, "&6" + skill.getData().getName() + "&2 was reset for &6" + player.getName(), silent, new CustomFilter[0]);
            } else {
                command.sendMessage(sender, NOT_FUNCTION, "&4That is not a valid function. Use up, down, or reset.", silent, new CustomFilter[0]);
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length == 2) {
            return ConfigurableCommand.getTabCompletions(List.of("up", "down", "reset"), (String[])new String[]{args[1]});
        }
        if (args.length > 2) {
            PlayerData playerData = Fabled.getData((OfflinePlayer)Bukkit.getPlayer((String)args[0]));
            if (playerData == null) {
                return null;
            }
            return ConfigurableCommand.getTabCompletions((Collection)playerData.getSkills().stream().map(playerSkill -> playerSkill.getData().getName()).collect(Collectors.toList()), (String[])Arrays.copyOfRange(args, 2, args.length));
        }
        return null;
    }
}

